<?php

namespace App\Console\Commands;

use App\Models\Admin;
use App\Models\TattooArtist;
use Illuminate\Console\Command;

class AdvancePaymentCollection extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'advancepayment:collection';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Comando para cobrar los descuentos recurrentes';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $tattooArtists = TattooArtist::where('isDeleted', false)->get();

        foreach ($tattooArtists as $tattooArtist) {
            $recurringCharges = $tattooArtist->recurringCharges
                ? $tattooArtist->recurringCharges
                : [];

            foreach ($recurringCharges as $recurringCharge) {
                $recurringCharge->collectPayment(time());
            }
        }
    }
}
