<?php

namespace App\Console\Commands;

use App\Mail\DeleteAccount;
use App\Models\Admin;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Storage;

class DeleteAccountCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'Delete:Account';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Comando para gestionar la eliminación de admins sin suscripción';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        Storage::disk('public')->put('file2.txt', "[" . date('Y-m-d H:i:s', time()) . "]: Delete account message");
        $admins = Admin::where('isDeleted', false)->get();

        foreach ($admins as $admin) {
            $currentDate = time();

            if (!$admin->deleteDate) continue;
            $deleteDate = strtotime($admin->deleteDate);
            $realDeleteDate = strtotime("$admin->deleteDate + 5 days");

            if ($currentDate >= $realDeleteDate) {
                $admin->business->deleteBusiness();
                $admin->deleteDate = null;
                $admin->save();

                echo 'Se eliminó el negocio';
            } else if ($currentDate >= $deleteDate && !$admin->deleteEmailSent) {
                $mail = new DeleteAccount($admin, env('WEB_APP_URL'));

                $admin->deleteEmailSent = true;
                $admin->save();

                Mail::to($admin->user->email)->send($mail);
                echo 'Se envió el correo';
            }
        }
    }
}
