<?php

namespace App\Console\Commands;

use App\Models\Admin;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Storage;

class SubscriptionMessage extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'subscription:message';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Comando para reestablecer el mensaje de que la suscripción está por acabarse';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        Storage::disk('public')->put('file1.txt', "[" . date('Y-m-d H:i:s', time()) . "]: Subscription:message");
        $admins = Admin::all();

        foreach ($admins as $admin) {

            if ($admin->endDate) {
                $dateShowMessage = strtotime("$admin->endDate - 7 days");
                $currentDate = time();

                if ($currentDate >= $dateShowMessage) {
                    $admin->subscriptionAlertSent = false;
                    $admin->save();
                }
            }
        }
    }
}
