<?php

namespace App\Console;

use App\Console\Commands\AdvancePaymentCollection;
use App\Console\Commands\DeleteAccountCommand;
use App\Console\Commands\EveryHalfHour;
use App\Console\Commands\SubscriptionMessage;
use App\Models\AdvancePayment;
use Illuminate\Console\Scheduling\Schedule;
use Laravel\Lumen\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        //
        EveryHalfHour::class,
        DeleteAccountCommand::class,
        SubscriptionMessage::class,
        AdvancePaymentCollection::class
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        //
        // $schedule->call(function () {
        //     echo date('Y-m-d H:i:s', time());
        // })->everyMinute()
        //     ->emailOutputTo('bernknox39@gmail.com');

        $schedule->command('Delete:Account')
            // ->everyFiveMinutes();
            ->daily()
            ->at('00:01');
        $schedule->command('subscription:message')
            // ->everyThreeMinutes();
            ->daily()
            ->at('00:01');
        $schedule->command('advancepayment:collection')
            ->daily()
            ->at('00:01');

        // $schedule->command('subscription:message')
        //     ->everyMinute();

        // $schedule->command('every:halfHour')
        //     ->everyMinute()
        //     ->appendOutputTo('scheduler.log');
        // ->emailOutputTo('bernknox39@gmail.com');
    }
}
