<?php

namespace App\Custom;

use App\Models\Operation;
use App\Models\TattooArtist;

class MailCustom
{
    const BIENVENIDA = "bienvenida";

    private static $footer = <<<HTML
        <img src="#" alt="logo"/>
        <span>Copyright © 2022 TATO, Todos los derechos reservados.</span>
    HTML;

    private static function paragraph($content) {
        return "{{ publicPath() }}";
    }

    private static $bienvenida = <<<HTML
        <p style="color: pink; background: black; margin: 2em; padding: 2em;">Hola,</p>
        <h2>{{1}}</h2>
        <p>Gracias por elegir TATO® como una de tus herramientas de trabajo. Nuestro sistema de punto de venta enfocado 100% al mundo de los estudios de tatuaje te permitirá llevar un registro de tus ingreso y un control de porcentajes para tus tatuadores.</p>
        <br />
        <p>Estamos confiados en que TATO® tendrá un impacto positivo en las operaciones de tu negocio, recortando tiempos y simplificando tareas.</p>
        {{footer}}
        <img src="#" alt="banner">
    HTML;

    private static function gtt($args = [], $template = "") {
        $template = self::${$template};
        return self::gts($args, $template);
    }

    private static function gts($args, $template) {
        for ($i = 1; $i <= sizeof($args); ++$i) {
            $template = str_replace("{{{$i}}}", $args[$i - 1], $template);
        }
        $template = str_replace("{{footer}}", self::$footer, $template);
        return $template;
    }

    public static function generateTemplate($args, $mailType) {
        // return self::gtt($args, $mailType);
        return self::paragraph("");

    }
}
