<?php

namespace App\Custom;

use App\Models\Operation;
use App\Models\TattooArtist;

class OperationCustom
{
    private $startDate;
    private $endDate;
    private $tattooArtistObjectId;

    public function __construct($startDate, $endDate, $tattooArtistObjectId = null)
    {
        $this->startDate = $startDate;
        $this->endDate = $endDate;
        $this->tattooArtistObjectId = $tattooArtistObjectId;
    }

    public function setStartDate($startDate)
    {
        $this->startDate = $startDate;
    }

    public function setEndDate($endDate)
    {
        $this->endDate = $endDate;
    }

    public function setTattooArtistObjectId($tattooArtistObjectId)
    {
        $this->tattooArtistObjectId = $tattooArtistObjectId;
    }

    public function getStartDate()
    {
        return $this->startDate;
    }

    public function getEndDate()
    {
        return $this->endDate;
    }

    public function getTattooArtistObjectId()
    {
        return $this->tattooArtistObjectId;
    }

    public function formatOperations($operations)
    {
        $formattedOperations = [];

        foreach ($operations as $operation) {
            $date = date('Y-m-d', strtotime($operation['date']));

            if (array_key_exists($date, $formattedOperations)) {
                $formattedOperations[$date][] = $operation;
            } else {
                $formattedOperations[$date] = [];
                $formattedOperations[$date][] = $operation;
            }
        }

        return $formattedOperations;
    }

    private function getOperationsQuery($where = [])
    {
        $tattooArtist = TattooArtist::find($this->tattooArtistObjectId);
        $startDate = date('Y-m-d', strtotime($this->startDate));
        $endDate = date('Y-m-d', strtotime("$this->endDate + 1 day"));

        $where[] = ['tattooArtistObjectId', $tattooArtist->objectId];

        return Operation::whereDate('date', '>=', $startDate)
            ->whereDate('date', '<', $endDate)
            ->where($where)
            ->orderBy('date', 'desc');
    }
    private function getSales()
    {
        return $this->getOperationsQuery([['saleObjectId', '!=', null]]);
    }
    private function getAdvancePayments()
    {
        return $this->getOperationsQuery([['advancePaymentObjectId', '!=', null]]);
    }
    private function getOperations()
    {
        return $this->getOperationsQuery();
    }

    public function sales()
    {
        return $this->getSales()->get();
    }
    public function advancePayments()
    {
        return $this->getAdvancePayments()->get();
    }
    public function operations()
    {
        return $this->getOperations()->get();
    }

    public function grossIncome()
    {
        return $this->getSales()->sum('amount');
    }
    public function advances()
    {
        return $this->sales()->each->sale->sum('sale.advance');
    }
    public function studioIncome()
    {
        $operations = $this->sales();
        $studioIncome = 0;
        foreach ($operations as $operation) {
            $studioPercentage = (1 - $operation->sale->salePercentage);
            $amount = $operation->amount;
            $studioIncome += $studioPercentage * $amount;
        }

        return $studioIncome;
    }
    public function tattooArtistIncome()
    {
        $operations = $this->sales();
        $advancePayments = $this->getAdvancePayments()->sum('amount');
        $tattooArtistIncome = 0;
        foreach ($operations as $operation) {
            $tattooArtistPercentage = $operation->sale->salePercentage;
            $amount = $operation->amount;
            // Si se menciona algo sobre el adelanto, aquí es:
            // $advance = $operation->sale->advance;
            $advance = 0;
            $tattooArtistIncome += $tattooArtistPercentage * ($amount + $advance);
        }

        return $tattooArtistIncome - $advancePayments;
    }

    public function summary()
    {
        return [
            'grossIncome' => $this->grossIncome(),
            'advances' => $this->advances(),
            'studioIncome' => $this->studioIncome(),
            'tattooArtistIncome' => $this->tattooArtistIncome()
        ];
    }
}
