<?php

namespace App\Custom;

use App\Mail\PayrollMail;
use App\Mail\SendEmail;
use App\Models\Payroll;
use Illuminate\Support\Facades\Mail;

class PayrollCustom
{
    public static function validateDates($data)
    {
        // $data = $request->all();
        $startDate = date('Y-m-d', strtotime($data['startDate']));
        $endDate = date('Y-m-d', strtotime($data['endDate']));
        $id = $data['tattooArtistObjectId'];

        $counter = 0;
        $counter += $startDate > $endDate;
        $counter += Payroll::whereDate('startDate', '<=', $endDate)
            ->whereDate('endDate', '>=', $startDate)
            ->where('tattooArtistObjectId', $id)
            ->count();

        return $counter == 0;
    }

    public static function sendPayroll($payroll)
    {
        $mail = new PayrollMail($payroll);
        // $mail = new SendEmail("En el siguiente enlace podrás ver tu reporte de corte: $payroll->pdf_url", "Reporte de corte");
        Mail::to($payroll->tattooArtist->user->email)->send($mail);
    }
}
