<?php

namespace App\Custom;

class PeriodicityCustom
{
    const MONTHLY = 1;
    const WEEKLY = 2;

    const MONDAY = 1;
    const TUESDAY = 2;
    const WEDNESDAY = 3;
    const THURSDAY = 4;
    const FRIDAY = 5;
    const SATURDAY = 6;
    const SUNDAY = 7;

    const WEEK_DAYS = [
        1 => 'MONDAY',
        2 => 'TUESDAY',
        3 => 'WEDNESDAY',
        4 => 'THURSDAY',
        5 => 'FRIDAY',
        6 => 'SATURDAY',
        7 => 'SUNDAY'
    ];

    public static function paymentDate($periodicity, $dayT)
    {
        $now = time();

        $day = null;
        $date = null;
        $dayToCompare = $dayT;
        switch ($periodicity) {
            case PeriodicityCustom::MONTHLY:
                $day = date('j', $now);
                $monthDays = date('t', $now);
                $nextMonthDays = date('t', strtotime('next month'));

                if ($dayT > $monthDays) {
                    $dayToCompare = $monthDays;
                }

                $diff = $dayToCompare - $day;

                if ($diff > 0) {
                    // en este mismo mes
                    $date = date('Y-m-d', strtotime("today + $diff days"));
                } else {
                    // el mes que viene
                    if ($dayT > $nextMonthDays) {
                        $dayToCompare = $nextMonthDays;
                    }

                    $dayToCompare -= 1;

                    $date = date('Y-m-d', strtotime("next month + $dayToCompare days"));
                }

                break;
            case PeriodicityCustom::WEEKLY:
                $day = PeriodicityCustom::WEEK_DAYS[$dayToCompare];
                $date = date('Y-m-d', strtotime("next $day"));
                break;
            default:
                return;
        }

        return $date;
    }
}
