<?php

namespace App\Custom;

use App\Models\Admin;
use App\Models\Business;
use App\Models\Plan;
use App\Models\SubscriptionLog;
use Illuminate\Support\Facades\DB;

class PlanCustom
{
    private $startDate;
    private $endDate;
    public function __construct($startDate, $endDate)
    {
        $this->startDate = $startDate;
        $this->endDate = $endDate;
    }

    public function getActivesInactives()
    {
        $now = date('Y-m-d H:i:s', time());
        $total = Admin::where([
            ['isDeleted', false],
            ['isDisabled', false],
        ])->count();

        $inactives = Admin::where([
            ['isDeleted', false],
            ['isDisabled', false],
        ])->where(function ($query) use ($now) {
            $query->whereDate('startDate', '>', $now)
                ->orWhereDate('endDate', '<', $now);
        })->orWhere('planObjectId', null)
            ->count();

        $actives = $total - $inactives;

        return [$actives, $inactives];
    }

    public function getPlansByType()
    {
        $current = date('Y-m-d', strtotime($this->startDate));
        $i = 0;

        $data = [];
        while (strtotime($current) <= strtotime($this->endDate)) {
            $next = date('Y-m-d', strtotime("$current + 1 day"));
            $data[$i] = [];
            // $results = Admin::with(['plan'])
            //     ->whereDate('startDate', '>=', $current)
            //     ->whereDate('startDate', '<', $next)
            //     ->where('planObjectId', '!=', null)
            //     ->select('planObjectId', DB::raw('count(*) as total'))
            //     ->groupBy('planObjectId')
            //     ->get();

            $results = SubscriptionLog::whereDate('startDate', '>=', $current)
                ->whereDate('startDate', '<', $next)
                ->where('planObjectId', '!=', null)
                ->select('planObjectId', DB::raw('count(*) as total'))
                ->groupBy('planObjectId')
                ->get();

            foreach ($results as $result) {
                $plan = Plan::find($result->planObjectId);
                $result['plan'] = $plan;
            }

            $data[$i][$current] = $results;
            ++$i;
            $current = date('Y-m-d', strtotime("$current + 1 day"));
        }

        return $data;
    }

    public function getPlansByCity()
    {
        // $total = Admin::where('planObjectId', '!=', null)
        //     ->whereDate('admins.startDate', '>=', $this->startDate)
        //     ->whereDate('admins.startDate', '<=', $this->endDate)
        //     ->count();

        // $users = Business::join('admins', 'admins.businessObjectId', '=', 'businesses.objectId')
        //     ->join('plans', 'plans.objectId', '=', 'admins.planObjectId')
        //     ->join('users', 'users.objectId', '=', 'admins.userObjectId')
        //     ->whereDate('admins.startDate', '>=', $this->startDate)
        //     ->whereDate('admins.startDate', '<=', $this->endDate)
        //     ->select('businesses.city', 'businesses.state', DB::raw('count(*) as total'))
        //     ->groupBy('businesses.city', 'businesses.state')
        //     ->orderBy('total', 'desc')
        //     ->get();

        $total = SubscriptionLog::where('planObjectId', '!=', null)
            ->whereDate('startDate', '>=', $this->startDate)
            ->whereDate('startDate', '<=', $this->endDate)
            ->count();

        $users = SubscriptionLog::where('planObjectId', '!=', null)
            ->whereDate('startDate', '>=', $this->startDate)
            ->whereDate('startDate', '<=', $this->endDate)
            ->select('city', 'state', DB::raw('count(*) as total'))
            ->groupBy('city', 'state')
            ->orderBy('total', 'desc')
            ->get();

        return [
            'total' => $total,
            'data' => $users
        ];
    }

    public function getPlansByPeriodicity()
    {
        $monthly = [
            'Plan Light' => 0,
            'Plan Pro' => 0,
            'Plan Empresarial' => 0
        ];
        $semiannually = [
            'Plan Light' => 0,
            'Plan Pro' => 0,
            'Plan Empresarial' => 0
        ];
        $anually = [
            'Plan Light' => 0,
            'Plan Pro' => 0,
            'Plan Empresarial' => 0
        ];

        $margin = 1339200;

        // $admins = Admin::where([
        //     ['planObjectId', '!=', null],
        // ])->whereDate('startDate', '>=', $this->startDate)
        //     ->whereDate('startDate', '<=', $this->endDate)
        //     ->get();
        $admins = SubscriptionLog::where([
            ['planObjectId', '!=', null],
        ])->whereDate('startDate', '>=', $this->startDate)
            ->whereDate('startDate', '<=', $this->endDate)
            ->get();

        foreach ($admins as $admin) {
            $startDate = strtotime($admin->startDate);
            $endDate = strtotime($admin->endDate);

            $plan = Plan::find($admin->planObjectId);

            $month = strtotime("$admin->startDate + 1 month") + $margin;
            $semester = strtotime("$admin->startDate + 6 month") + $margin;
            $year = strtotime("$admin->startDate + 1 year") + $margin;

            if ($endDate <= $month) {
                $monthly[$plan->name] += 1;
            } else if ($endDate <= $semester) {
                $semiannually[$plan->name] += 1;
            } else if ($endDate <= $year) {
                $anually[$plan->name] += 1;
            }
        }

        return [
            0 => ['Mensual' => $monthly],
            1 => ['Semestral' => $semiannually],
            2 => ['Anual' => $anually]
        ];
    }
}
