<?php

namespace App\Custom;

class StripeIntervalCustom
{
    private static $SINGULAR = 0;
    private static $PLURAL = 1;

    private static $INTERVAL = [
        'year' => ['año', 'años'],
        'month' => ['mes', 'meses']
    ];

    private static function getIntervalLabel($interval = '', $intervalCount = null)
    {
        $option = $intervalCount == 1
            ? self::$SINGULAR
            : self::$PLURAL;

        $intervalExists = array_key_exists($interval, self::$INTERVAL);

        $intervalLabel = $intervalExists
            ? self::$INTERVAL[$interval][$option]
            : $interval;

        return "$intervalCount $intervalLabel";
    }

    private static function getPriceLabel($unitAmount = '')
    {
        return '$' . number_format($unitAmount / 100, 2);
    }

    public static function getLabel($data)
    {
        $intervalLabel = self::getIntervalLabel($data['interval'], $data['intervalCount']);
        $priceLabel = self::getPriceLabel($data['unitAmount']);
        return "$priceLabel/$intervalLabel";
    }
}
