<?php

namespace App\Http\Controllers;

use App\Custom\StripeErrorMessages;
use App\Mail\SetPassword;
use App\Models\Admin;
use App\Models\Business;
use App\Models\Studio;
use App\Models\User;
use App\Traits\FilesTrait;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Illuminate\Validation\ValidationException;
use Stripe\Exception\ApiConnectionException;
use Stripe\Exception\ApiErrorException;
use Stripe\Exception\AuthenticationException;
use Stripe\Exception\CardException;
use Stripe\Exception\InvalidRequestException;
use Stripe\Exception\RateLimitException;
use Stripe\StripeClient;
use Illuminate\Support\Str;

class AdminController extends Controller
{
    use FilesTrait;
    // public function index() {
    //     try {
    //         $admins = Admin::all();
    //     } catch (ModelNotFoundException $e) {
    //         return response()->json(['error' => 'No content 1'], 406);
    //     } catch (\Throwable $e) {
    //         return response()->json(['error' => 'No content 2'], 406);
    //     }
    // }

    // public function show($uuid) {
    //     try {
    //         $admin = Admin::with(['user'])->find($uuid);
    //         if (!$admin) return response()->json(['error' => 'Bad URI'], 404);

    //         return response()->json(['admin' => $admin], 200);
    //     } catch (ModelNotFoundException $e) {
    //         return response()->json(['error' => 'No content 1'], 406);
    //     } catch (\Throwable $e) {
    //         return response()->json(['error' => 'No content 2'], 406);
    //     }
    // }
    public function showAdminAsAdmin()
    {
        try {
            $id = Auth::user()->objectId;
            $admin = Admin::with(['user'])->where([
                ['isDeleted', false]
            ])->find($id);
            if (!$admin) return response()->json(['error' => 'Bad URI'], 404);

            return response()->json(['admin' => $admin], 200);
        } catch (ModelNotFoundException $e) {
            return response()->json(['error' => 'No content 1'], 406);
        } catch (\Throwable $e) {
            return response()->json(['error' => 'No content 2'], 406);
        }
    }

    public function updateAdminAsAdmin(Request $request)
    {
        try {
            DB::beginTransaction();

            $this->validate($request, $this->validator($request));

            $id = Auth::user()->objectId;
            $admin = Admin::with(['user'])->where([
                ['isDeleted', false]
            ])->find($id);
            if (!$admin) return response()->json(['error' => 'Bad URI'], 404);
            $user = $admin->user;
            if (!$user) return response()->json(['error' => 'Bad URI'], 404);

            $data = $request->all();
            unset($data['password']);
            unset($data['photo']);
            unset($data['email']);

            $user->update($data);
            $admin->update($data);

            if ($request->hasFile('photo')) {
                $user->photo = $this->createFile('users', 'profilePhoto', $user->objectId, $request->photo);
                $user->save();
            }

            DB::commit();

            return response()->json([
                'message' => 'Usuario actualizado correctamente',
                'admin' => Admin::with('user')->find($admin->objectId)
            ], 200);
        } catch (ModelNotFoundException $e) {
            DB::rollBack();
            return response()->json(['error' => 'No content 1'], 406);
        } catch (ValidationException $e) {
            DB::rollBack();
            return response()->json(['error' => 'Bad Request', 'errors' => $e->errors()], 400);
        } catch (\Throwable $e) {
            DB::rollBack();
            return response()->json(['error' => $e->getMessage()], 406);
        }
    }

    private function validator($request)
    {
        $max_file = env('UPLOAD_MAX_FILESIZE');

        $data = $request->all();
        $rules = [
            'name' => 'required',
            'email' => 'nullable|min:5|max:60|regex:/^.+@.+[.]+.+$/',
            'photo' => "nullable|max:$max_file"
        ];

        $toValidate = [];
        foreach ($rules as $field => $rule) {
            if (array_key_exists($field, $data)) {
                $toValidate[$field] = $rule;
            }
        }

        return $toValidate;
    }

    public function hideAlert(Request $request)
    {
        try {
            $adminObjectId = Auth::user()->objectId;

            $admin = Admin::where('isDeleted', false)->find($adminObjectId);

            $admin->subscriptionAlertSent = true;
            $admin->save();

            return response()->json([
                'message' => 'Alerta ocultada exitosamente'
            ], 200);
        } catch (\Throwable $e) {
            return response()->json([
                'e' => $e->getMessage()
            ], 406);
        }
    }

    public function enable(Request $request, $id)
    {
        try {
            $admin = Admin::find($id);
            $admin->update([
                'isDeleted' => false
            ]);
            $admin->user->update([
                'isDeleted' => false
            ]);

            return response()->json([
                // 'message' => 'Usuario creado exitosamente',
                'admin' => Admin::find($admin->objectId)
            ], 201);
        } catch (ModelNotFoundException $e) {
            DB::rollBack();
            return response()->json(['error' => 'No content 1'], 406);
        } catch (ValidationException $e) {
            DB::rollBack();
            return response()->json(['error' => 'Bad Request', 'errors' => $e->errors()], 400);
        } catch (\Throwable $e) {
            DB::rollBack();
            return response()->json(['error' => $e->getMessage()], 406);
        }
    }

    public function store(Request $request)
    {
        try {
            DB::beginTransaction();

            $data = $request->all();
            unset($data['password']);
            unset($data['photo']);

            $data['name'] = $request->studioName;
            $business = Business::create($data);

            $data['name'] = $request->studioName;
            $data['businessObjectId'] = $business->objectId;
            $studio = Studio::create($data);

            $data['name'] = $request->adminName;
            $data['password'] = Str::random(150);

            $validUser = User::where([
                ['email', $data['email']],
                ['isDeleted', false]
            ])->count() == 0;

            if (!$validUser) return response()->json(['error' => 'Ya existe una cuenta con este correo'], 406);

            $user = User::create($data);

            $data['userObjectId'] = $user->objectId;
            $data['planObjectId'] = $request->plan;
            $admin = Admin::create($data);

            // $stripe = new StripeClient(env('STRIPE_SECRET_KEY'));

            // aquí iba el customer

            // $admin->update([
            //     'customerId' => $request->customerId
            // ]);
            $admin->update([
                'isDeleted' => true
            ]);
            $user->update([
                'isDeleted' => true
            ]);

            // aquí iba la suscripcióon

            $recoveryCode = Str::random(8);
            $user->recoveryCode = $recoveryCode;
            $user->save();

            $mail = new SetPassword($user);
            Mail::to($user->email)->send($mail);

            DB::commit();

            return response()->json([
                'message' => 'Usuario creado exitosamente',
                'admin' => Admin::find($admin->objectId)
            ], 201);
        } catch (ModelNotFoundException $e) {
            DB::rollBack();
            return response()->json(['error' => 'No content 1'], 406);
        } catch (ValidationException $e) {
            DB::rollBack();
            return response()->json(['error' => 'Bad Request', 'errors' => $e->errors()], 400);
        } catch (\Throwable $e) {
            DB::rollBack();
            return response()->json(['error' => $e->getMessage()], 406);
        }
    }

    // public function update(Request $request, $uuid) {
    //     try {
    //         //code...
    //     } catch (ModelNotFoundException $e) {
    //         return response()->json(['error' => 'No content 1'], 406);
    //     } catch (ValidationException $e) {
    //         return response()->json(['error' => 'Bad Request', 'errors' => $e->errors()], 400);
    //     } catch (\Throwable $e) {
    //         return response()->json(['error' => 'No content 2'], 406);
    //     }
    // }

    // public function destroy($uuid) {
    //     try {
    //         //code...
    //     } catch (ModelNotFoundException $e) {
    //         return response()->json(['error' => 'No content 1'], 406);
    //     } catch (\Throwable $e) {
    //         return response()->json(['error' => 'No content 2'], 406);
    //     }
    // }
}
