<?php

namespace App\Http\Controllers;

use App\Models\AdvancePayment;
use App\Models\Operation;
use App\Models\TattooArtist;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Validation\ValidationException;

class AdvancePaymentController extends Controller
{
    public function store(Request $request)
    {
        try {
            DB::beginTransaction();

            $this->validate($request, $this->validator($request));

            $data = $request->all();

            $tattooArtist = TattooArtist::find($request->tattooArtistObjectId);
            if (!$tattooArtist) return response()->json(['error' => 'Bad URI'], 404);

            $businessObjectId = $tattooArtist->studio->businessObjectId;
            if ($businessObjectId != Auth::user()->businessObjectId) {
                return response()->json(['error' => 'Bad URI'], 404);
            }

            $advancePayment = AdvancePayment::create([]);

            $data['advancePaymentObjectId'] = $advancePayment->objectId;
            $data['tattooArtistObjectId'] = $request->tattooArtistObjectId;
            $data['studioObjectId'] = $tattooArtist->studioObjectId;
            $operation = Operation::create($data);

            DB::commit();

            return response()->json([
                'message' => 'Adelanto creado correctamente',
                'operation' => Operation::where('advancePaymentObjectId', $advancePayment->objectId)->first()
            ], 201);
        } catch (ModelNotFoundException $e) {
            DB::rollBack();
            return response()->json(['error' => 'No content 1'], 406);
        } catch (ValidationException $e) {
            DB::rollBack();
            return response()->json(['error' => 'Bad Request', 'errors' => $e->errors()], 400);
        } catch (\Throwable $e) {
            DB::rollBack();
            return response()->json(['error' => $e->getMessage()], 406);
        }
    }

    private function validator($request)
    {
        $data = $request->all();
        $rules = [
            'amount' => 'required|regex:/^(?!0\d)\d*(\.\d+)?$/',
            'concept' => 'nullable',
            'date' => 'required',
            'tattooArtistObjectId' => 'required',
        ];

        $toValidate = [];
        foreach ($rules as $field => $rule) {
            if (array_key_exists($field, $data)) {
                $toValidate[$field] = $rule;
            }
        }

        return $toValidate;
    }
}
