<?php

namespace App\Http\Controllers;

use App\Models\Business;
use App\Models\Studio;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;

class BusinessStudioController extends Controller
{
    public function index($id) {
        try {
            $business = Business::where('isDeleted', false)->find($id);

            if (!$business) return response()->json(['error' => 'Bad URI'], 404);

            $studios = Studio::where([
                ['businessObjectId', $business->objectId],
                ['isDeleted', false]
            ])->get();

            return response()->json(['studios' => $studios], 200);
        } catch (ModelNotFoundException $e) {
            return response()->json(['error' => 'No content 1'], 406);
        } catch (\Throwable $e) {
            return response()->json(['error' => 'No content 2'], 406);
        }
    }
}
