<?php

namespace App\Http\Controllers;

use App\Custom\DashboardCustom;
use App\Custom\OperationCustom;
use App\Custom\PayrollCustom;
use App\Custom\PlanCustom;
use App\Models\Business;
use App\Models\ProductPurchase;
use App\Models\ProductPurchaseItem;
use App\Models\Sale;
use App\Models\TattooArtist;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Validator;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Cell\Coordinate;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Writer\Exception;

class ExcelController extends Controller
{
    public function superAdminDashboardSpreadSheet(Request $request)
    {
        try {
            $document = new Spreadsheet();
            $document->getDefaultStyle()
                ->getFont()
                ->setName('Arial')
                ->setSize('12');

            $tableHead = [
                'font' => [
                    'bold' => true
                ],
                'borders' => [
                    'bottom' => [
                        'borderStyle' => Border::BORDER_THIN
                    ],
                ],
            ];

            $planCustom = new PlanCustom($request->startDate, $request->endDate);
            $activeInactives = $planCustom->getActivesInactives();
            $plansByCity = $planCustom->getPlansByCity();
            $plansByPeriodicity = $planCustom->getPlansByPeriodicity();
            $plansByType = $planCustom->getPlansByType();

            $document->setActiveSheetIndex(0);

            $sheet = $document->getActiveSheet();
            $sheet->setCellValue('A1', "Registro de clientes ($request->startDate a $request->endDate)");
            $sheet->mergeCells('A1:E1');
            $sheet->setTitle('Activos, Inactivos y ubicación');
            $sheet->getStyle(1, 1)
                ->getAlignment()
                ->setHorizontal(Alignment::HORIZONTAL_CENTER);
            $sheet->getStyle(1, 1)
                ->getAlignment()
                ->setVertical(Alignment::VERTICAL_CENTER);

            $column = 1;
            $row = 3;
            $sheet->getColumnDimensionByColumn($column)->setWidth(20);
            $sheet->getColumnDimensionByColumn($column + 1)->setWidth(20);
            $sheet->setCellValueByColumnAndRow($column, $row, "Planes activos/inactivos al " . date('Y-m-d H:i', time()));
            $sheet->mergeCellsByColumnAndRow($column, $row, $column + 1, $row);
            $sheet->getStyle('A3:B3')
                ->getAlignment()
                ->setHorizontal(Alignment::HORIZONTAL_CENTER);
            $sheet->getStyle('A3:B3')
                ->getAlignment()
                ->setVertical(Alignment::VERTICAL_CENTER);

            $sheet->setCellValueByColumnAndRow($column, $row + 1, 'Activos');
            $sheet->setCellValueByColumnAndRow($column + 1, $row + 1, 'Inactivos');

            if (array_key_exists(0, $activeInactives)) {
                $sheet->setCellValueByColumnAndRow($column, $row + 2, $activeInactives[0] ?? '0');
            } else {
                $sheet->setCellValueByColumnAndRow($column, $row + 2, '0');
            }
            if (array_key_exists(1, $activeInactives)) {
                $sheet->setCellValueByColumnAndRow($column + 1, $row + 2, $activeInactives[1] ?? '0');
            } else {
                $sheet->setCellValueByColumnAndRow($column + 1, $row + 2, $activeInactives[1] ?? '0');
            }

            $column = 4;
            $sheet->getColumnDimensionByColumn($column)->setWidth(30);
            $sheet->getColumnDimensionByColumn($column + 1)->setWidth(30);
            $sheet->setCellValueByColumnAndRow($column, $row, "Planes por ubicación");
            $sheet->mergeCellsByColumnAndRow($column, $row, $column + 1, $row);
            $sheet->getStyle('D3:E3')
                ->getAlignment()
                ->setHorizontal(Alignment::HORIZONTAL_CENTER);
            $sheet->getStyle('D3:E3')
                ->getAlignment()
                ->setVertical(Alignment::VERTICAL_CENTER);

            if (array_key_exists('total', $plansByCity)) {
                $sheet->setCellValueByColumnAndRow($column, $row + 1, 'Ventas totales: ' . $plansByCity['total'] ?? '0');
            } else {
                $sheet->setCellValueByColumnAndRow($column, $row + 1, 'Ventas totales: ' . '0');
            }

            $sheet->mergeCellsByColumnAndRow($column, $row + 1, $column + 1, $row + 1);
            $sheet->getStyle('D4:E4')
                ->getAlignment()
                ->setHorizontal(Alignment::HORIZONTAL_CENTER);
            $sheet->getStyle('D4:E4')
                ->getAlignment()
                ->setVertical(Alignment::VERTICAL_CENTER);

            $sheet->setCellValueByColumnAndRow($column, $row + 2, 'Ventas');
            $sheet->setCellValueByColumnAndRow($column + 1, $row + 2, 'Ciudad');

            $i = 1;
            if (array_key_exists('data', $plansByCity)) {
                foreach ($plansByCity['data'] as $data) {
                    $sheet->setCellValueByColumnAndRow($column, $row + $i + 2, $data['total'] ?? '0');

                    $address = ($data['state'] ?? '') . ', ' . ($data['city'] ?? '');
                    $address = $address == ', ' ? 'Sin ubicación' : $address;
                    $sheet->setCellValueByColumnAndRow($column + 1, $row + $i + 2, $address);
                    ++$i;
                }
            }

            $document->createSheet();
            $document->setActiveSheetIndex(1);

            $sheet = $document->getActiveSheet();
            $sheet->setCellValue('A1', "Registro de clientes ($request->startDate a $request->endDate)");
            $sheet->mergeCells('A1:E1');
            $sheet->setTitle('Periodicidad');
            $sheet->getStyle(1, 1)
                ->getAlignment()
                ->setHorizontal(Alignment::HORIZONTAL_CENTER);
            $sheet->getStyle(1, 1)
                ->getAlignment()
                ->setVertical(Alignment::VERTICAL_CENTER);

            $column = 1;
            $row = 3;

            $sheet->getColumnDimensionByColumn($column)->setWidth(20);
            $sheet->getColumnDimensionByColumn($column + 1)->setWidth(10);
            $sheet->getColumnDimensionByColumn($column + 2)->setWidth(10);
            $sheet->getColumnDimensionByColumn($column + 3)->setWidth(10);
            $sheet->setCellValueByColumnAndRow($column, $row, "Ventas por periodicidad");
            $sheet->mergeCellsByColumnAndRow($column, $row, $column + 3, $row);
            $sheet->getStyle('A3:B3')
                ->getAlignment()
                ->setHorizontal(Alignment::HORIZONTAL_CENTER);
            $sheet->getStyle('A3:B3')
                ->getAlignment()
                ->setVertical(Alignment::VERTICAL_CENTER);

            $sheet->setCellValue('B4', 'Mensual');
            $sheet->setCellValue('C4', 'Semestral');
            $sheet->setCellValue('D4', 'Anual');
            $sheet->setCellValue('A5', 'Plan Light');
            $sheet->setCellValue('A6', 'Plan Pro');
            $sheet->setCellValue('A7', 'Plan Empresarial');

            $monthly = $plansByPeriodicity[0]['Mensual'];
            $semianually = $plansByPeriodicity[1]['Semestral'];
            $anually = $plansByPeriodicity[2]['Anual'];

            $sheet->setCellValue('B5', $monthly['Plan Light']) ?? 0;
            $sheet->setCellValue('B6', $monthly['Plan Pro']) ?? 0;
            $sheet->setCellValue('B7', $monthly['Plan Empresarial']) ?? 0;
            $sheet->setCellValue('C5', $semianually['Plan Light'] ?? 0);
            $sheet->setCellValue('C6', $semianually['Plan Pro'] ?? 0);
            $sheet->setCellValue('C7', $semianually['Plan Empresarial'] ?? 0);
            $sheet->setCellValue('D5', $anually['Plan Light'] ?? 0);
            $sheet->setCellValue('D6', $anually['Plan Pro'] ?? 0);
            $sheet->setCellValue('D7', $anually['Plan Empresarial'] ?? 0);

            $document->createSheet();
            $document->setActiveSheetIndex(2);

            $sheet = $document->getActiveSheet();
            $sheet->setCellValue('A1', "Registro de clientes ($request->startDate a $request->endDate)");
            $sheet->mergeCells('A1:E1');
            $sheet->setTitle('Tipo');
            $sheet->getStyle(1, 1)
                ->getAlignment()
                ->setHorizontal(Alignment::HORIZONTAL_CENTER);
            $sheet->getStyle(1, 1)
                ->getAlignment()
                ->setVertical(Alignment::VERTICAL_CENTER);

            $column = 1;
            $row = 3;

            $sheet->getColumnDimensionByColumn($column)->setWidth(20);
            $sheet->getColumnDimensionByColumn($column + 1)->setWidth(20);
            $sheet->getColumnDimensionByColumn($column + 2)->setWidth(20);
            $sheet->getColumnDimensionByColumn($column + 3)->setWidth(20);
            $sheet->setCellValueByColumnAndRow($column, $row, "Ventas por tipo de plan");
            $sheet->mergeCellsByColumnAndRow($column, $row, $column + 3, $row);
            $sheet->getStyle('A3:B3')
                ->getAlignment()
                ->setHorizontal(Alignment::HORIZONTAL_CENTER);
            $sheet->getStyle('A3:B3')
                ->getAlignment()
                ->setVertical(Alignment::VERTICAL_CENTER);

            $sheet->setCellValue('B4', 'Plan Light');
            $sheet->setCellValue('C4', 'Plan Pro');
            $sheet->setCellValue('D4', 'Plan Empresarial');

            $columns = ['B', 'C', 'D'];

            if ($plansByType && is_array($plansByType)) {
                foreach ($plansByType as $index => $plan) {

                    if (is_array($plan)) {
                        foreach ($plan as $date => $values) {
                            foreach ($columns as $indexJ => $column) {
                                $sheet->setCellValue(
                                    $column . (((count($plansByType ?? []) ?? 0) - $index + $row + 1) ?? '0'),
                                    '0'
                                );
                            }
                        }
                    }
                }

                foreach ($plansByType as $index => $plan) {
                    foreach ($plan as $date => $values) {
                        $sheet->setCellValue('A' . (((count($plansByType ?? []) ?? 0) - $index + $row + 1) ?? '0'), $date ?? 'Sin fecha');

                        foreach ($columns as $indexJ => $column) {
                            $valuesArr = json_decode(json_encode($values));

                            if (array_key_exists($indexJ, $valuesArr)) {
                                $cell = '';

                                if (array_key_exists($indexJ, $valuesArr)) {
                                    $value = $valuesArr[$indexJ]->total ?? '0';

                                    if ($valuesArr[$indexJ]->plan) {
                                        switch ($valuesArr[$indexJ]->plan->name) {
                                            case 'Plan Light':
                                                $cell = 'B';
                                                break;
                                            case 'Plan Pro':
                                                $cell = 'C';
                                                break;
                                            case 'Plan Empresarial':
                                                $cell = 'D';
                                                break;
                                        }

                                        $sheet->setCellValue(
                                            $cell . (((count($plansByType ?? []) ?? 0) - $index + $row + 1) ?? '0'),
                                            $value
                                        );
                                    }
                                }
                            }
                        }
                    }
                }
            }

            $xlsx = new Xlsx($document);
            $fileName = "registro_$request->startDate" . "_a_" . "$request->endDate" . "_" . strtotime('now') . ".xlsx";
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment; filename="' . urlencode($fileName) . '"');
            $xlsx->save($fileName);
            $fileContent = file_get_contents($fileName);
            unlink($fileName);

            return response()->json([
                'fileName' => $fileName,
                'content' => base64_encode($fileContent)
            ]);
        } catch (Exception $e) {
            return response()->json([
                'error' => $e->getMessage()
            ], 400);
        } catch (\Throwable $e) {
            return response()->json([
                'error' => $e->getMessage()
            ], 406);
        }
    }

    public function payrollSpreadsheet(Request $request)
    {
        try {
            $tattooArtistsInfo = $request->tattooArtists
                ? json_decode($request->tattooArtists)
                : [];
            $document = new Spreadsheet();
            $document->getDefaultStyle()
                ->getFont()
                ->setName('Arial')
                ->setSize('12');

            $tableHead = [
                'font' => [
                    'bold' => true
                ],
                'borders' => [
                    'bottom' => [
                        'borderStyle' => Border::BORDER_THIN
                    ],
                ],
            ];

            $activeIndex = 0;
            foreach ($tattooArtistsInfo as $tattooArtistInfo) {
                // $isValid = PayrollCustom::validateDates([
                //     'startDate' => $request->startDate,
                //     'endDate' => $request->endDate,
                //     'tattooArtistObjectId' => $tattooArtistInfo
                // ]);
                // if (!$isValid) continue;

                $tattooArtist = TattooArtist::find($tattooArtistInfo);
                if (!$tattooArtist) continue;

                $businessObjectId = $tattooArtist->studio->businessObjectId;
                if ($businessObjectId != Auth::user()->businessObjectId) continue;

                $operationCustom = new OperationCustom(
                    $request->startDate,
                    $request->endDate,
                    $tattooArtistInfo
                );

                $sales = $operationCustom->sales();
                $advancePayments = $operationCustom->advancePayments();
                $summary = $operationCustom->summary();

                $document->setActiveSheetIndex($activeIndex);
                $sheet = $document->getActiveSheet();
                $sheet->getColumnDimension('A')->setWidth(20);
                $sheet->getColumnDimension('B')->setWidth(20);
                $sheet->getColumnDimension('C')->setWidth(20);
                $sheet->getColumnDimension('D')->setWidth(15);
                $sheet->getColumnDimension('E')->setWidth(15);
                $sheet->getColumnDimension('F')->setWidth(15);
                $sheet->getColumnDimension('G')->setWidth(15);
                $sheet->getColumnDimension('H')->setWidth(15);
                $sheet->getColumnDimension('I')->setWidth(20);
                // // título
                $sheet->setCellValue('A1', "Hoja de registro ($request->startDate a $request->endDate)");
                $sheet->mergeCells('A1:I1');
                $sheet->setTitle(substr($tattooArtist->user->name, 0, 31));
                $sheet->getStyle(1, 1)
                    ->getAlignment()
                    ->setHorizontal(Alignment::HORIZONTAL_CENTER);
                $sheet->getStyle(1, 1)
                    ->getAlignment()
                    ->setVertical(Alignment::VERTICAL_CENTER);

                $sheet->setCellValueByColumnAndRow(1, 2, "Tatuador");
                $sheet->setCellValueByColumnAndRow(2, 2, $tattooArtist->user->name);

                $sheet->setCellValueByColumnAndRow(3, 2, "Ingreso bruto");
                $sheet->setCellValueByColumnAndRow(4, 2, $summary['grossIncome']);

                $sheet->setCellValueByColumnAndRow(3, 3, "Ingreso tienda");
                $sheet->setCellValueByColumnAndRow(4, 3, $summary['studioIncome']);

                $sheet->setCellValueByColumnAndRow(3, 4, "Anticipos");
                $sheet->setCellValueByColumnAndRow(4, 4, $summary['advances']);

                $sheet->setCellValueByColumnAndRow(3, 5, "Ingreso tatuador");
                $sheet->setCellValueByColumnAndRow(4, 5, $summary['tattooArtistIncome']);

                $sheet->getStyle("D2:D5")
                    ->getNumberFormat()
                    ->setFormatCode(NumberFormat::FORMAT_CURRENCY_USD_SIMPLE);
                $sheet->getStyle('A7:I7')->applyFromArray($tableHead);
                $sheet->getStyle('A1:I1')->applyFromArray($tableHead);

                $sheet->setCellValueByColumnAndRow(1, 7, "Cliente");
                $sheet->setCellValueByColumnAndRow(2, 7, "Medio");
                $sheet->setCellValueByColumnAndRow(3, 7, "Tatuaje (concepto)");
                $sheet->setCellValueByColumnAndRow(4, 7, "Anticipo");
                $sheet->setCellValueByColumnAndRow(5, 7, "Pago");
                $sheet->setCellValueByColumnAndRow(6, 7, "Tienda");
                $sheet->setCellValueByColumnAndRow(7, 7, "Tatuador");
                $sheet->setCellValueByColumnAndRow(8, 7, "Cobrado");
                $sheet->setCellValueByColumnAndRow(9, 7, "Observaciones");

                for ($i = 0; $i < count($sales); ++$i) {
                    $sale = $sales[$i];
                    $sheet->setCellValueByColumnAndRow(1, $i + 8, $sale->sale->clientName);
                    $sheet->setCellValueByColumnAndRow(
                        2,
                        $i + 8,
                        $sale->sale->paymentMethod->type == 'Otro'
                            ? ($sale->sale->otherPaymentMethod ?? 'Otro')
                            : $sale->sale->paymentMethod->type
                    );
                    $sheet->setCellValueByColumnAndRow(3, $i + 8, $sale->concept);
                    $sheet->setCellValueByColumnAndRow(4, $i + 8, $sale->sale->advance ?? "NA");
                    $sheet->setCellValueByColumnAndRow(5, $i + 8, $sale->amount ?? 0);
                    $sheet->setCellValueByColumnAndRow(6, $i + 8, $sale->amount * (1 - $sale->sale->salePercentage));
                    $sheet->setCellValueByColumnAndRow(7, $i + 8, $sale->amount * $sale->sale->salePercentage);

                    $sheet->getStyle("D8:G" . ($i + 8))
                        ->getNumberFormat()
                        ->setFormatCode(NumberFormat::FORMAT_CURRENCY_USD_SIMPLE);
                }

                for ($i = 0; $i < count($advancePayments); ++$i) {
                    $advancePayment = $advancePayments[$i];
                    $sheet->setCellValueByColumnAndRow(8, $i + 8, "-$advancePayment->amount");
                    $sheet->setCellValueByColumnAndRow(9, $i + 8, $advancePayment->concept);
                    $sheet->getStyle("H8:H" . ($i + 8))
                        ->getNumberFormat()
                        ->setFormatCode(NumberFormat::FORMAT_CURRENCY_USD_SIMPLE);
                }

                if (array_key_exists($activeIndex + 1, $tattooArtistsInfo)) {
                    $document->createSheet();
                    $document->setActiveSheetIndex(++$activeIndex);
                    $document->getActiveSheet()->setTitle('0');
                }
            }
            $document->setActiveSheetIndex(0);

            // ob_clean();
            // $xlsx = new Xlsx($document);
            // header('Content-Type: application/vnd.ms-excel');
            // header('Content-Disposition: attachment; filename="file.xls"');
            // $xlsx->save('php://output');

            // ob_clean();
            $xlsx = new Xlsx($document);
            $fileName = "corte_$request->startDate" . "_a_" . "$request->endDate" . "_" . strtotime('now') . ".xlsx";
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment; filename="' . urlencode($fileName) . '"');
            $xlsx->save($fileName);
            $fileContent = file_get_contents($fileName);
            unlink($fileName);

            return response()->json([
                'fileName' => $fileName,
                'content' => base64_encode($fileContent)
            ]);
        } catch (Exception $e) {
            return response()->json([
                'error' => $e->getMessage()
            ], 400);
        } catch (\Throwable $e) {
            return response()->json([
                'error' => $e->getMessage()
            ], 406);
        }

        // // tamaño de columna
        // $sheet->getColumnDimension('A')->setWidth(30);

        // // Color de columnas
        // $tableHead = [
        //     'font' => [
        //         'color' => [
        //             'rgb' => 'FFFFFF'
        //         ],
        //         'bold' => true,
        //         'size' => 14
        //     ],
        //     'fill' => [
        //         'fillType' => Fill::FILL_SOLID,
        //         'startColor' => [
        //             'rgb' => '538ED5'
        //         ]
        //     ]
        // ];
        // $sheet->getStyle('A2:I2')->applyFromArray($tableHead);

        // $styleArray = array(
        //     'borders' => array(
        //         'allBorders' => array(
        //             'borderStyle' => Border::BORDER_THICK,
        //             'color' => array('argb' => 'FFFF0000'),
        //         ),
        //     ),
        // );
        // $sheet->getStyle('A3:I10')->applyFromArray($styleArray);

        // $sheet->setCellValueByColumnAndRow(1, 2, "Id de médico");
        // $sheet->setCellValueByColumnAndRow(2, 2, "Nombre de médico");
        // $sheet->setCellValueByColumnAndRow(3, 2, "Cédula 1");
        // $sheet->setCellValueByColumnAndRow(4, 2, "Especialidad 1");
        // $sheet->setCellValueByColumnAndRow(5, 2, "Cédula 2");
        // $sheet->setCellValueByColumnAndRow(6, 2, "Especialidad 2");
        // $sheet->setCellValueByColumnAndRow(7, 2, "Cédula 3");
        // $sheet->setCellValueByColumnAndRow(8, 2, "Especialidad 3");
        // $sheet->setCellValueByColumnAndRow(9, 2, "Validado");


        // for ($i = 3; $i < 20; ++$i) {
        //     $sheet->setCellValueByColumnAndRow(1, $i, $i);
        //     $sheet->setCellValueByColumnAndRow(2, $i, $i);
        //     $sheet->setCellValueByColumnAndRow(3, $i, $i);
        //     $sheet->setCellValueByColumnAndRow(4, $i, $i);
        //     $sheet->setCellValueByColumnAndRow(5, $i, $i);
        //     $sheet->setCellValueByColumnAndRow(6, $i, $i);
        //     $sheet->setCellValueByColumnAndRow(7, $i, $i);
        //     $sheet->setCellValueByColumnAndRow(8, $i, $i);
        //     $sheet->setCellValueByColumnAndRow(9, $i, $i);

        //     $sheet->getStyle(Coordinate::stringFromColumnIndex(9) . $i)
        //         ->getNumberFormat()
        //         ->setFormatCode(NumberFormat::FORMAT_CURRENCY_USD_SIMPLE);
        // }

        // $document->createSheet();
        // // Zero based, so set the second tab as active sheet
        //
        // $document->getActiveSheet()->setTitle('Second tab');

        // ob_clean();
        // $xlsx = new Xlsx($document);
        // header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        // header('Content-Disposition: attachment; filename="' . urlencode("corte.xlsx") . '"');
        // $xlsx->save('php://output');
    }

    public function formatProductPurchase($productPurchase) {
        $productPurchase = ProductPurchase::find($productPurchase->objectId);
        $productPurchaseItems = ProductPurchaseItem::where('isDeleted', false)
            ->where('productPurchaseObjectId', $productPurchase->objectId)
            ->get();
        // $sale = Sale::with(['paymentMethod'])->find($productPurchase->saleObjectId);
        $tattooArtist = TattooArtist::find($productPurchase->tattooArtistObjectId);

        $productPurchase['productPurchaseItems'] = $productPurchaseItems;
        // $productPurchase['sale'] = $sale;
        $productPurchase['tattooArtist'] = $tattooArtist;

        return $productPurchase;
    }

    public function dashboard(Request $request, $id)
    {
        try {
            $business = Auth::user()->business;
            if (!$business) return response()->json([
                'error' => 'Negocio no válido.'
            ], 404);

            $studio = $business->studios()
                ->where('isDeleted', false)
                ->find($id);

            if (!$studio) return response()->json([
                'error' => 'Estudio no válido.'
            ], 404);

            $data = [
                'monthlyIncoming' => DashboardCustom::getMonthlyIncoming($id),
                'productMonthlyIncoming' => DashboardCustom::getProductMonthlyIncoming($id),
                'tattooArtistMonthlyIncoming' => DashboardCustom::getTattooArtistMonthlyIncoming($id)
            ];

            $startDate = date('Y-m-01');
            $endDate = date('Y-m-d');

            $document = new Spreadsheet();
            $document->getDefaultStyle()
                ->getFont()
                ->setName('Arial')
                ->setSize('12');

            $tableHead = [
                'font' => [
                    'bold' => true
                ],
                'borders' => [
                    'bottom' => [
                        'borderStyle' => Border::BORDER_THIN
                    ],
                ],
            ];

            $document->setActiveSheetIndex(0);
            $sheet = $document->getActiveSheet();
            $sheet->getColumnDimension('A')->setWidth(10);
            $sheet->getColumnDimension('B')->setWidth(15);
            $sheet->getColumnDimension('C')->setWidth(15);
            $sheet->getColumnDimension('D')->setWidth(5);
            $sheet->getColumnDimension('E')->setWidth(15);
            $sheet->getColumnDimension('F')->setWidth(10);
            $sheet->getColumnDimension('G')->setWidth(15);
            $sheet->getColumnDimension('H')->setWidth(5);
            $sheet->getColumnDimension('I')->setWidth(17);
            $sheet->getColumnDimension('J')->setWidth(17);
            // // título
            $sheet->setCellValue('A1', "Registro de ingresos ($startDate a $endDate)");
            $sheet->mergeCells('A1:J1');
            $sheet->setTitle(substr('Registro de ingresos', 0, 31));
            $sheet->getStyle(1, 1)
                ->getAlignment()
                ->setHorizontal(Alignment::HORIZONTAL_CENTER);
            $sheet->getStyle(1, 1)
                ->getAlignment()
                ->setVertical(Alignment::VERTICAL_CENTER);

            $sheet->setCellValue('A3', 'Ventas de tatuajes y productos mensuales');
            $sheet->mergeCells('A3:C3');
            $sheet->getStyle(3, 1)
                ->getAlignment()
                ->setHorizontal(Alignment::HORIZONTAL_CENTER);
            $sheet->getStyle(3, 1)
                ->getAlignment()
                ->setVertical(Alignment::VERTICAL_CENTER);

            $sheet->setCellValue('E3', 'Ventas de de productos mensuales');
            $sheet->mergeCells('E3:G3');
            $sheet->getStyle(3, 5)
                ->getAlignment()
                ->setHorizontal(Alignment::HORIZONTAL_CENTER);
            $sheet->getStyle(3, 5)
                ->getAlignment()
                ->setVertical(Alignment::VERTICAL_CENTER);

            $sheet->setCellValue('I3', 'Acumulado mensual por tatuador');
            $sheet->mergeCells('I3:J3');
            $sheet->getStyle(3, 9)
                ->getAlignment()
                ->setHorizontal(Alignment::HORIZONTAL_CENTER);
            $sheet->getStyle(3, 9)
                ->getAlignment()
                ->setVertical(Alignment::VERTICAL_CENTER);

            $sheet->getStyle('A4:C4')->applyFromArray($tableHead);
            $sheet->getStyle('E4:G4')->applyFromArray($tableHead);
            $sheet->getStyle('I4:J4')->applyFromArray($tableHead);
            $sheet->getStyle('A1:J1')->applyFromArray($tableHead);
            $sheet->getStyle('A3:C3')->applyFromArray($tableHead);
            $sheet->getStyle('E3:G3')->applyFromArray($tableHead);
            $sheet->getStyle('I3:J3')->applyFromArray($tableHead);

            $sheet->setCellValueByColumnAndRow(1, 4, 'Fecha');
            $sheet->setCellValueByColumnAndRow(2, 4, 'Tatuajes');
            $sheet->setCellValueByColumnAndRow(3, 4, 'Productos');

            $row = 5;

            $monthlyIncoming = $data['monthlyIncoming'];
            $tattoos = $monthlyIncoming['datasets'][0];
            $products = $monthlyIncoming['datasets'][1];

            for ($i = 0; $i < count($monthlyIncoming['labels']); ++$i) {
                $date = $monthlyIncoming['labels'][$i];
                $tattoo = $tattoos['data'][$i];
                $product = $products['data'][$i];

                $sheet->setCellValueByColumnAndRow(1, $i + $row, $date);
                $sheet->setCellValueByColumnAndRow(2, $i + $row, $tattoo);
                $sheet->setCellValueByColumnAndRow(3, $i + $row, $product);
            }

            $sheet->getStyle("B4:C" . ($i + $row))
                ->getNumberFormat()
                ->setFormatCode(NumberFormat::FORMAT_CURRENCY_USD_SIMPLE);

            $column = 4;
            $sheet->setCellValueByColumnAndRow(1 + $column, 4, 'Producto');
            $sheet->setCellValueByColumnAndRow(2 + $column, 4, 'Cantidad');
            $sheet->setCellValueByColumnAndRow(3 + $column, 4, 'Ingreso');

            $productIncoming = $data['productMonthlyIncoming'];
            $productQuantities = $productIncoming['productPurchases'];
            $productLabels = $productIncoming['labels'];
            $productData = $productIncoming['datasets'][0]['data'];

            for ($i = 0; $i < count($productLabels); ++$i) {
                $productName = $productLabels[$i];
                $productNumber = $productData[$i];
                $productPurchase = $productQuantities[$i];
                $sheet->setCellValueByColumnAndRow(1 + $column, $row + $i, $productName);
                $sheet->setCellValueByColumnAndRow(2 + $column, $row + $i, $productPurchase->quantity);
                $sheet->setCellValueByColumnAndRow(3 + $column, $row + $i, $productNumber);
            }

            $sheet->getStyle("G4:G" . ($i + $row))
                ->getNumberFormat()
                ->setFormatCode(NumberFormat::FORMAT_CURRENCY_USD_SIMPLE);

            $column = 8;
            $sheet->setCellValueByColumnAndRow(1 + $column, 4, 'Tatuador');
            $sheet->setCellValueByColumnAndRow(2 + $column, 4, 'Ingreso');

            $tattooArtistIncoming = $data['tattooArtistMonthlyIncoming'];
            $tattooArtistsNames = $tattooArtistIncoming['labels'];
            $TattooArtistsData = $tattooArtistIncoming['datasets'][0]['data'];

            for ($i = 0; $i < count($tattooArtistsNames); ++$i) {
                $tattooArtistName = $tattooArtistsNames[$i];
                $tattooArtistIncome = $TattooArtistsData[$i];

                $sheet->setCellValueByColumnAndRow(1 + $column, $i + $row, $tattooArtistName);
                $sheet->setCellValueByColumnAndRow(2 + $column, $i + $row, $tattooArtistIncome);
            }

            $sheet->getStyle("J4:J" . ($i + $row))
                ->getNumberFormat()
                ->setFormatCode(NumberFormat::FORMAT_CURRENCY_USD_SIMPLE);

            $document->setActiveSheetIndex(0);

            $xlsx = new Xlsx($document);
            $fileName = "registro_ingresos_$startDate" . "_a_" . "$endDate" . "_" . strtotime('now') . ".xlsx";
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment; filename="' . urlencode($fileName) . '"');
            $xlsx->save($fileName);
            $fileContent = file_get_contents($fileName);
            unlink($fileName);

            return response()->json([
                'fileName' => $fileName,
                'content' => base64_encode($fileContent)
            ]);

        } catch (Exception $e) {
            return response()->json([
                'error' => $e->getMessage()
            ], 400);
        } catch (\Throwable $e) {
            return response()->json([
                'error' => $e->getMessage()
            ], 406);
        }
    }

    public function productPurchaseSpreadsheet(Request $request)
    {
        try {
            $rules = [
                'startDate' => 'sometimes|date',
                'endDate' => 'sometimes|date',
            ];
            $messages = [
                'startDate.date' => 'Fecha de inicio incorrecta.',
                'endDate.date' => 'Fecha de fin incorrecta.'
            ];

            $validator = Validator::make($request->all(), $rules, $messages);
            if ($validator->fails()) {
                return response()->json([
                    'error'=> $validator->errors()->first()
                ], 400);
            }

            $business = Business::where('isDeleted', false)
                ->find(Auth::user()->businessObjectId);

            if (!$business) return response()->json([
                'error' => 'Negocio no válido.'
            ], 400);

            $endDate = $request->endDate
                ? date('Y-m-d', strtotime($request->endDate))
                : date('Y-m-d');
            $startDate = $request->startDate
                ? date('Y-m-d', strtotime($request->startDate))
                : date('Y-m-d', strtotime("$endDate - 7 days"));

            $productPurchases = ProductPurchase::where('businessObjectId', $business->objectId)
                ->where('isDeleted', false)
                ->whereDate('created_at', '>=', $startDate)
                ->whereDate('created_at', '<=', $endDate)
                ->orderBy('created_at', 'DESC')
                ->get();

            foreach($productPurchases as $key => $productPurchase) {
                $productPurchases[$key] = $this->formatProductPurchase($productPurchase);
            }

            $document = new Spreadsheet();
            $document->getDefaultStyle()
                ->getFont()
                ->setName('Arial')
                ->setSize('12');

            $tableHead = [
                'font' => [
                    'bold' => true
                ],
                'borders' => [
                    'bottom' => [
                        'borderStyle' => Border::BORDER_THIN
                    ],
                ],
            ];

            $document->setActiveSheetIndex(0);
            $sheet = $document->getActiveSheet();
            $sheet->getColumnDimension('A')->setWidth(20);
            $sheet->getColumnDimension('B')->setWidth(20);
            $sheet->getColumnDimension('C')->setWidth(20);
            $sheet->getColumnDimension('D')->setWidth(20);
            $sheet->getColumnDimension('E')->setWidth(20);
            $sheet->getColumnDimension('F')->setWidth(25);
            $sheet->getColumnDimension('G')->setWidth(15);
            $sheet->getColumnDimension('H')->setWidth(15);
            $sheet->getColumnDimension('I')->setWidth(15);
            $sheet->getColumnDimension('J')->setWidth(15);
            $sheet->getColumnDimension('K')->setWidth(15);
            // // título
            $sheet->setCellValue('A1', "Ventas de productos ($startDate a $endDate)");
            $sheet->mergeCells('A1:K1');
            $sheet->setTitle(substr('Mi título', 0, 31));
            $sheet->getStyle(1, 1)
                ->getAlignment()
                ->setHorizontal(Alignment::HORIZONTAL_CENTER);
            $sheet->getStyle(1, 1)
                ->getAlignment()
                ->setVertical(Alignment::VERTICAL_CENTER);

            // $sheet->setCellValueByColumnAndRow(1, 2, "Tatuador");
            // $sheet->setCellValueByColumnAndRow(2, 2, 'Nombre del tatuador');

            $sheet->getStyle("D2:D5")
                ->getNumberFormat()
                ->setFormatCode(NumberFormat::FORMAT_CURRENCY_USD_SIMPLE);
            $sheet->getStyle('A4:K4')->applyFromArray($tableHead);
            $sheet->getStyle('A1:K1')->applyFromArray($tableHead);

            $sheet->setCellValueByColumnAndRow(1, 4, "");
            $sheet->setCellValueByColumnAndRow(2, 4, "Fecha");
            $sheet->setCellValueByColumnAndRow(3, 4, "Tatuador");
            $sheet->setCellValueByColumnAndRow(4, 4, "Cliente");
            $sheet->setCellValueByColumnAndRow(5, 4, "Medio");
            $sheet->setCellValueByColumnAndRow(6, 4, "Producto");
            $sheet->setCellValueByColumnAndRow(7, 4, "Cantidad");
            $sheet->setCellValueByColumnAndRow(8, 4, "Precio");
            $sheet->setCellValueByColumnAndRow(9, 4, "Pago");
            $sheet->setCellValueByColumnAndRow(10, 4, "Cancelado");
            $sheet->setCellValueByColumnAndRow(11, 4, "Total");
            $row = 5;
            foreach ($productPurchases as $key => $productPurchase) {

                foreach($productPurchase['productPurchaseItems'] as $productPurchaseItem) {
                    $sheet->setCellValueByColumnAndRow(1, $row, $key + 1);
                    $sheet->setCellValueByColumnAndRow(2, $row, date('Y-m-d H:i:s', strtotime($productPurchase->created_at)));
                    $sheet->setCellValueByColumnAndRow(3, $row, $productPurchase['tattooArtist']->user->name);
                    $sheet->setCellValueByColumnAndRow(4, $row, $productPurchase->clientName);
                    $sheet->setCellValueByColumnAndRow(5, $row, $productPurchase->paymentMethod);
                    $sheet->setCellValueByColumnAndRow(6, $row, $productPurchaseItem->name);
                    $sheet->setCellValueByColumnAndRow(7, $row, $productPurchaseItem->quantity);
                    $sheet->setCellValueByColumnAndRow(8, $row, $productPurchaseItem->price);
                    $sheet->setCellValueByColumnAndRow(9, $row, $productPurchaseItem->quantity * $productPurchaseItem->price);
                    $sheet->setCellValueByColumnAndRow(10, $row, $productPurchaseItem->isCancelled ? 'Sí' : 'No');
                    ++$row;
                }
                $sheet->setCellValueByColumnAndRow(11, $row - 1, $productPurchase->total);
            }

            $sheet->getStyle("H5:K" . ($row))
                ->getNumberFormat()
                ->setFormatCode(NumberFormat::FORMAT_CURRENCY_USD_SIMPLE);

            $document->setActiveSheetIndex(0);

            $xlsx = new Xlsx($document);
            $fileName = "venta_productos_$startDate" . "_a_" . "$endDate" . "_" . strtotime('now') . ".xlsx";
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment; filename="' . urlencode($fileName) . '"');
            $xlsx->save($fileName);
            $fileContent = file_get_contents($fileName);
            unlink($fileName);

            return response()->json([
                'fileName' => $fileName,
                'content' => base64_encode($fileContent)
            ]);
        } catch (Exception $e) {
            return response()->json([
                'error' => $e->getMessage()
            ], 400);
        } catch (\Throwable $e) {
            return response()->json([
                'error' => $e->getMessage()
            ], 406);
        }
    }
}
