<?php

namespace App\Http\Controllers;

use App\Custom\FormCustom;
use App\Models\Business;
use App\Models\Form;
use App\Models\FormResponse;
use App\Models\Question;
use App\Models\Response;
use App\Models\Studio;
use App\Traits\FilesTrait;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class FormResponseController extends Controller
{

    use FilesTrait;
    public function store(Request $request) {
        try {
            DB::beginTransaction();
            $data = $request->all();

            if (!array_key_exists('studioObjectId', $data)) {
                return response()->json([
                    'error' => 'El id del estudio es requerido.'
                ], 400);
            }

            $studio = Studio::where('isDeleted', false)
                ->find($data['studioObjectId']);

            if (!$studio) return response()->json([
                'error' => 'Estudio no válido.'
            ], 404);

            if (!array_key_exists('formObjectId', $data)) {
                return response()->json([
                    'error' => 'El id del formulario es requerido.'
                ], 400);
            }

            if (!array_key_exists('signature', $data)) {
                return response()->json([
                    'error' => 'La firma es requerida.'
                ], 400);
            }

            $form = Form::where('isDeleted', false)
                ->find($data['formObjectId']);
            if (!$form) return response()->json([
                'error' => 'Formulario no válido.'
            ], 400);

            if (!array_key_exists('responses', $data)) {
                return response()->json([
                    'error' => 'Las respuestas son requeridas.'
                ], 400);
            }

            $responses = json_decode($data['responses'], true);
            if (!is_array($responses)) {
                return response()->json([
                    'error' => 'Las respuestas deben ser un arreglo.'
                ], 400);
            }

            $formResponse = FormResponse::create([
                'formObjectId' => $form->objectId,
                'studioObjectId' => $studio->objectId,
            ]);

            foreach($responses as $questionObjectId => $response) {
                $question = Question::where('isDeleted', false)
                    ->find($questionObjectId);
                if (!$question) return response()->json([
                    'error' => 'Pregunta no válida.'
                ], 400);

                if (!(is_string($response) || is_array($response) || is_numeric($response))) {
                    return response()->json([
                        'error' => 'Respuesta no válida.'
                    ], 400);
                }

                if (is_string($response) && $question->type == FormCustom::CHECKBOX) {
                    return response()->json([
                        'error' => 'La respuesta debe ser un arreglo.'
                    ], 400);
                }

                if (is_array($response) && ($question->type != FormCustom::CHECKBOX && $question->type != FormCustom::TERMS)) {
                    return response()->json([
                        'error' => 'La respuesta debe ser una cadena de texto.'
                    ], 400);
                }

                $response = Response::create([
                    'questionNumber' => $question->questionNumber,
                    'question' => $question->question,
                    'data' => is_array($response) ? $response : [$response],
                    'type' => $question->type,
                    'required' => $question->required,
                    'formResponseObjectId' => $formResponse->objectId,
                ]);
            }

            if ($request->hasFile('signature')) {
                $path = "forms/$form->objectId/formResponses";
                $formResponse->signature = $this->createFile(
                    $path,
                    'signature',
                    $formResponse->objectId,
                    $request->signature
                );
                $formResponse->save();
            }

            DB::commit();
            return response()->json([
                'message' => 'Tus respuestas han sido enviadas.'
            ], 201);
        } catch (ModelNotFoundException $e) {
            DB::rollBack();
            return response()->json(['error' => 'No content 1'], 406);
        } catch (\Throwable $e) {
            DB::rollBack();
            return response()->json(['error' => $e->getMessage()], 406);
        }
    }

    public function update(Request $request) {
        try {
            DB::beginTransaction();
            $data = $request->all();

            // if (!array_key_exists('signature', $data)) {
            //     return response()->json([
            //         'error' => 'La firma es requerida.'
            //     ], 400);
            // }

            $tattooArtist = Auth::user();
            $studio = Studio::where('isDeleted', false)
                ->find($tattooArtist->studioObjectId);

            if (!$studio) return response()->json([
                'error' => 'Estudio no válido.'
            ], 404);

            $business = Business::where('isDeleted', false)
                ->find($studio->businessObjectId);

            if (!$business) return response()->json([
                'error' => 'Negocio no válido.'
            ], 404);

            $form = Form::where('isDeleted', false)
            ->where('businessObjectId', $business->objectId)
            ->first();

            if (!$form) return response()->json([
                'error' => 'Formulario no válido.'
            ], 400);

            if (!array_key_exists('formResponseObjectId', $data)) {
                return response()->json([
                    'error' => 'El id de las respuestas es requerido.'
                ], 400);
            }

            $formResponse = FormResponse::where('formObjectId', $form->objectId)
                ->find($data['formResponseObjectId']);

            if (!$formResponse) return response()->json([
                'error' => 'Respuestas no válidas.'
            ], 404);

            if (!array_key_exists('responses', $data)) {
                return response()->json([
                    'error' => 'Las respuestas son requeridas.'
                ], 400);
            }

            $responses = json_decode($data['responses'], true);
            if (!is_array($responses)) {
                return response()->json([
                    'error' => 'Las respuestas deben ser un arreglo.'
                ], 400);
            }

            $responsesC = Response::where('formResponseObjectId', $formResponse->objectId)
                ->where('isDeleted', false)
                ->get();

            $responsesC->each->delete();

            foreach($responses as $questionObjectId => $response) {
                $question = Question::where('isDeleted', false)
                    ->find($questionObjectId);
                if (!$question) return response()->json([
                    'error' => 'Pregunta no válida.'
                ], 400);

                if (!(is_string($response) || is_array($response) || is_numeric($response))) {
                    return response()->json([
                        'error' => 'Respuesta no válida.'
                    ], 400);
                }

                if (is_string($response) && $question->type == FormCustom::CHECKBOX) {
                    return response()->json([
                        'error' => 'La respuesta debe ser un arreglo.'
                    ], 400);
                }

                if (is_array($response) && ($question->type != FormCustom::CHECKBOX && $question->type != FormCustom::TERMS)) {
                    return response()->json([
                        'error' => 'La respuesta debe ser una cadena de texto.'
                    ], 400);
                }

                $response = Response::create([
                    'questionNumber' => $question->questionNumber,
                    'question' => $question->question,
                    'data' => is_array($response) ? $response : [$response],
                    'type' => $question->type,
                    'required' => $question->required,
                    'formResponseObjectId' => $formResponse->objectId,
                ]);


            }

            // if ($request->hasFile('signature')) {
            //     $path = "forms/$form->objectId/formResponses";
            //     $formResponse->signature = $this->createFile(
            //         $path,
            //         'signature',
            //         $formResponse->objectId,
            //         $request->signature
            //     );
            //     $formResponse->save();
            // }

            DB::commit();
            return response()->json([
                'message' => 'Tus respuestas han sido enviadas.'
            ], 201);
        } catch (ModelNotFoundException $e) {
            DB::rollBack();
            return response()->json(['error' => 'No content 1'], 406);
        } catch (\Throwable $e) {
            DB::rollBack();
            return response()->json(['error' => $e->getMessage()], 406);
        }
    }

    public function destroy(Request $request, $id) {
        try {
            DB::beginTransaction();
            $form = Form::where('isDeleted', false)
            ->where('businessObjectId', Auth::user()->businessObjectId)
            ->first();

            if (!$form) return response()->json([
                'error' => 'Formulario no válido.'
            ], 400);

            $formResponse = FormResponse::where('isDeleted', false)
                ->where('formObjectId', $form->objectId)
                ->find($id);

            if (!$formResponse) return response()->json([
                'error' => 'Registro no válido.'
            ], 404);

            $formResponse->deleteFormResponse();

            DB::commit();
            return response()->json([
                'message' => 'Registro eliminado exitosamente.'
            ], 200);
        } catch (ModelNotFoundException $e) {
            DB::rollBack();
            return response()->json(['error' => 'No content 1'], 406);
        } catch (\Throwable $e) {
            DB::rollBack();
            return response()->json(['error' => $e->getMessage()], 406);
        }
    }

    public function destroyForTattoo(Request $request, $id) {
        try {
            DB::beginTransaction();

            $tattooArtist = Auth::user();
            $studio = Studio::where('isDeleted', false)
                ->find($tattooArtist->studioObjectId);

            if (!$studio) return response()->json([
                'error' => 'Estudio no válido.'
            ], 404);

            $business = Business::where('isDeleted', false)
                ->find($studio->businessObjectId);

            if (!$business) return response()->json([
                'error' => 'Negocio no válido.'
            ], 404);

            $form = Form::where('isDeleted', false)
            ->where('businessObjectId', $business->objectId)
            ->first();

            if (!$form) return response()->json([
                'error' => 'Formulario no válido.'
            ], 400);

            $formResponse = FormResponse::where('isDeleted', false)
                ->where('formObjectId', $form->objectId)
                ->find($id);

            if (!$formResponse) return response()->json([
                'error' => 'Registro no válido.'
            ], 404);

            $formResponse->deleteFormResponse();

            DB::commit();
            return response()->json([
                'message' => 'Registro eliminado exitosamente.'
            ], 200);
        } catch (ModelNotFoundException $e) {
            DB::rollBack();
            return response()->json(['error' => 'No content 1'], 406);
        } catch (\Throwable $e) {
            DB::rollBack();
            return response()->json(['error' => $e->getMessage()], 406);
        }
    }
}
