<?php

namespace App\Http\Controllers;

use App\Custom\OperationCustom;
use App\Custom\PayrollCustom;
use App\Models\Form;
use App\Models\Operation;
use App\Models\Payroll;
use App\Models\ProductPurchase;
use App\Models\ProductPurchaseItem;
use App\Models\Sale;
use App\Models\TattooArtist;
use Barryvdh\DomPDF\Facade as PDF;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;
use SimpleSoftwareIO\QrCode\Facades\QrCode;

class PDFController extends Controller
{
    public function formatProductPurchase($productPurchase) {
        $productPurchase = ProductPurchase::find($productPurchase->objectId);
        $productPurchaseItems = ProductPurchaseItem::where('isDeleted', false)
            ->where('productPurchaseObjectId', $productPurchase->objectId)
            ->get();
        // $sale = Sale::with(['paymentMethod'])->find($productPurchase->saleObjectId);
        $tattooArtist = TattooArtist::find($productPurchase->tattooArtistObjectId);

        $productPurchase['productPurchaseItems'] = $productPurchaseItems;
        // $productPurchase['sale'] = $sale;
        $productPurchase['tattooArtist'] = $tattooArtist;

        return $productPurchase;
    }
    public function saleTicket($id)
    {
        try {
            $operation = Operation::where([['saleObjectId', '!=', null]])
                ->find($id);
            if (!$operation) return redirect()->back()->withInput();

            $productPurchase = ProductPurchase::where('isDeleted', false)
                ->where('saleObjectId', $operation->sale->objectId)
                ->first();

            if ($productPurchase)
                $productPurchase = $this->formatProductPurchase($productPurchase);

            $pdf = PDF::loadView('pdf.sale-ticket', [
                'operation' => $operation,
                'productPurchase' => $productPurchase
            ]);
            $timeStamp = time();
            return $pdf->stream("ticket_venta_$timeStamp.pdf");
        } catch (ModelNotFoundException $e) {
            return response()->json(['error' => 'No content 1'], 406);
        } catch (\Throwable $e) {
            return response()->json(['error' => $e->getMessage()], 406);
        }
    }

    public function formQr($id, $studio) {
        try {
            $form = Form::where('isDeleted', false)
                ->find($id);
            if (!$form) return redirect()->back()->withInput();

            $qrcode = base64_encode(
                QrCode::format('png')
                    ->size(550)
                    ->color(42, 42, 42)
                    // ->backgroundColor(255, 0, 255)
                    ->generate("$form->response_url/$studio/responder")
            );
            $pdf = PDF::loadView('pdf.form-qr', [
                'form' => $form,
                'qrcode' => $qrcode,
                'studio' => $studio
            ]);
            return $pdf->stream("formulario-qr-$form->objectId.pdf");
        } catch (ModelNotFoundException $e) {
            return response()->json(['error' => 'No content 1'], 406);
        } catch (\Throwable $e) {
            return response()->json(['error' => $e->getMessage()], 406);
        }
    }

    public function payrollPdf($id)
    {
        try {
            $payroll = Payroll::find($id);
            if (!$payroll) return redirect()->back();

            $operationCustom = new OperationCustom($payroll->startDate, $payroll->endDate, $payroll->tattooArtistObjectId);
            $operations = $operationCustom->operations();
            $formattedOperations = $operationCustom->formatOperations($operations);
            $summary = $operationCustom->summary();

            $pdf = PDF::loadView('pdf.payroll', [
                'payroll' => $payroll,
                'operations' => $formattedOperations,
                'summary' => $summary
            ]);

            $timeStamp = time();
            return $pdf->stream("corte_$timeStamp.pdf");
        } catch (ModelNotFoundException $e) {
            return response()->json(['error' => 'No content 1'], 406);
        } catch (\Throwable $e) {
            return response()->json(['error' => $e->getMessage()], 406);
        }
    }
}
