<?php

namespace App\Http\Controllers;

use App\Models\PaymentMethod;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;

class PaymentMethodController extends Controller
{
    public function index() {
        try {
            $paymentMethods = PaymentMethod::all();

            return response()->json(['paymentMethods' => $paymentMethods], 200);
        } catch (ModelNotFoundException $e) {
            return response()->json(['error' => 'No content 1'], 406);
        } catch (\Throwable $e) {
            return response()->json(['error' => $e->getMessage()], 406);
        }
    }
}
