<?php

namespace App\Http\Controllers;

use App\Custom\PlanCustom;
use App\Models\Admin;
use App\Models\Business;
use App\Models\Plan;
use App\Models\Studio;
use App\Models\TattooArtist;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class PlanController extends Controller
{
    public function plansInfo(Request $request)
    {
        try {
            $admin = Auth::user();
            $plans = Plan::all();
            $currentPlan = Plan::find($admin->planObjectId);

            $businessObjectId = $admin->businessObjectId;

            $studios = Studio::where([
                ['isDeleted', false],
                ['businessObjectId', $businessObjectId]
            ])->get();

            $studiosCount = Studio::where([
                ['isDeleted', false],
                ['businessObjectId', $businessObjectId]
            ])->count();

            $tattooArtists = 0;

            foreach ($studios as $studio) {
                $currentTattooArtists = TattooArtist::where([
                    ['isDeleted', false],
                    ['studioObjectId', $studio->objectId]
                ])->count();

                $tattooArtists += $currentTattooArtists;
            }

            return response()->json([
                'plans' => $plans,
                'currentPlan' => $currentPlan,
                'studios' => $studiosCount,
                'tattooArtists' => $tattooArtists
            ], 200);
        } catch (\Throwable $e) {
            return response()->json(['error' => $e->getMessage()], 406);
        }
    }
    public function getActivesInactives(Request $request)
    {
        try {
            $planCustom = new PlanCustom(
                $request->startDate,
                $request->endDate
            );
            $data = $planCustom->getActivesInactives();

            return response()->json([
                'data' => $data
            ], 200);
        } catch (\Throwable $e) {
            return response()->json([
                'error' => 'Ocurrió un error'
            ], 406);
        }
    }

    public function getPlansByType(Request $request)
    {
        try {
            $planCustom = new PlanCustom(
                $request->startDate,
                $request->endDate
            );
            $data = $planCustom->getPlansByType();

            return response()->json([
                'data' => $data
            ], 200);
        } catch (\Throwable $e) {
            return response()->json([
                'error' => 'Ocurrió un error'
            ], 406);
        }
    }

    public function getPlansByCity(Request $request)
    {
        try {
            $planCustom = new PlanCustom(
                $request->startDate,
                $request->endDate
            );
            $data = $planCustom->getPlansByCity();

            return response()->json([
                'res' => $data
            ], 200);
        } catch (\Throwable $e) {
            return response()->json([
                'error' => 'Ocurrió un error'
            ], 406);
        }
    }

    public function getPlansByPeriodicity(Request $request)
    {
        try {
            $planCustom = new PlanCustom(
                $request->startDate,
                $request->endDate
            );
            $data = $planCustom->getPlansByPeriodicity();

            return response()->json([
                'data' => $data
            ], 200);
        } catch (\Throwable $e) {
            return response()->json([
                'error' => 'Ocurrió un error'
            ], 406);
        }
    }
}
