<?php

namespace App\Http\Controllers;

use App\Models\ProductPurchase;
use App\Models\ProductPurchaseItem;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class ProductPurchaseItemController extends Controller
{
    public function cancelProductPurchaseItem(Request $request, $id) {
        try {
            DB::beginTransaction();

            $productPurchaseItem = ProductPurchaseItem::where('isDeleted', false)
                ->where('isCancelled', false)
                ->find($id);

            if (!$productPurchaseItem) return response()->json([
                'error' => 'Producto no válido.'
            ], 400);

            $productPurchase = ProductPurchase::where('isDeleted', false)
                ->find($productPurchaseItem->productPurchaseObjectId);

            if (!$productPurchase) return response()->json([
                'error' => 'Producto no válido.'
            ], 400);

            if ($productPurchase->businessObjectId != Auth::user()->businessObjectId) {
                return response()->json([
                    'error' => 'Producto no válido.'
                ], 400);
            }

            $productPurchaseItem->isCancelled = true;
            $productPurchaseItem->save();

            DB::commit();
            return response()->json([
                'message' => 'Producto cancelado exitosamente.'
            ], 200);
        } catch (ModelNotFoundException $e) {
            DB::rollBack();
            return response()->json(['error' => 'No content 1'], 406);
        } catch (\Throwable $e) {
            DB::rollBack();
            return response()->json(['error' => 'No content 2', 'msg' => $e->getMessage()], 406);
        }
    }
}
