<?php

namespace App\Http\Controllers;

use App\Custom\PeriodicityCustom;
use Illuminate\Http\Request;

class RecurringChargeController extends Controller
{
    public function getNextPaymentDate(Request $request)
    {
        try {
            $date = PeriodicityCustom::paymentDate(
                $request->periodicity,
                $request->day
            );

            return response()->json([
                'date' => $date
            ], 200);
        } catch (\Throwable $e) {
            return response()->json([
                'error' => 'Ocurrió un error'
            ], 406);
        }
    }
}
