<?php

namespace App\Http\Controllers;

use App\Custom\MailCustom;
use App\Mail\SendEmail;
use App\Mail\TicketMail;
use App\Models\Operation;
use App\Models\PaymentMethod;
use App\Models\Sale;
use App\Models\Studio;
use App\Models\TattooArtist;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Illuminate\Validation\ValidationException;

class SaleController extends Controller
{
    public function index()
    {
        // try {
        //     $tattooArtists = TattooArtist::with(['user'])
        //         ->where('isDeleted', false)
        //         ->get();

        //     return response()->json(['tattooArtists' => $tattooArtists], 200);
        // } catch (ModelNotFoundException $e) {
        //     return response()->json(['error' => 'No content 1'], 406);
        // } catch (\Throwable $e) {
        //     return response()->json(['error' => $e->getMessage()], 406);
        // }
    }

    public function show($id)
    {
        // try {
        //     $tattooArtist = TattooArtist::with(['user'])
        //         ->where('isDeleted', false)
        //         ->find($id);

        //     if (!$tattooArtist) return response()->json(['error' => 'Bad URI'], 404);

        //     return response()->json(['tattooArtist' => $tattooArtist], 200);
        // } catch (ModelNotFoundException $e) {
        //     return response()->json(['error' => 'No content 1'], 406);
        // } catch (\Throwable $e) {
        //     return response()->json(['error' => 'No content 2'], 406);
        // }
    }

    public function store(Request $request)
    {
        try {
            DB::beginTransaction();

            $this->validate($request, $this->validator($request));

            $data = $request->all();

            $tattooArtist = TattooArtist::find($request->tattooArtistObjectId);
            if (!$tattooArtist) return response()->json(['error' => 'Bad URI'], 404);
            if ($tattooArtist->studioObjectId != Auth::user()->studioObjectId) {
                return response()->json(['error' => 'Bad URI'], 404);
            }

            $salePercentage = $tattooArtist->salePercentage;

            $paymentMethod = PaymentMethod::where('type', 'Otro')->first();
            $data['salePercentage'] = $salePercentage;
            $data['paymentMethodObjectId'] = $request->paymentMethodObjectId;

            if ($paymentMethod->objectId != $request->paymentMethodObjectId) {
                unset($data['otherPaymentMethod']);
            }

            $sale = Sale::create($data);

            $data['saleObjectId'] = $sale->objectId;
            $data['tattooArtistObjectId'] = $request->tattooArtistObjectId;
            $data['studioObjectId'] = $tattooArtist->studioObjectId;
            $data['date'] = date('Y-m-d H:i:s', strtotime('now'));
            $operation = Operation::create($data);

            DB::commit();

            return response()->json([
                'message' => 'Venta registrada correctamente',
                'operation' => Operation::where('saleObjectId', $sale->objectId)->first()
            ], 201);
        } catch (ModelNotFoundException $e) {
            DB::rollBack();
            return response()->json(['error' => 'No content 1'], 406);
        } catch (ValidationException $e) {
            DB::rollBack();
            return response()->json(['error' => 'Bad Request', 'errors' => $e->errors()], 400);
        } catch (\Throwable $e) {
            DB::rollBack();
            return response()->json(['error' => $e->getMessage()], 406);
        }
    }

    public function sendTicket(Request $request, $id)
    {
        try {
            $this->validate($request, [
                'email' => 'nullable|min:5|max:60|regex:/^.+@.+[.]+.+$/'
            ]);

            $operation = Operation::find($id);
            $sale = $operation->sale;
            $sale->clientEmail = $request->email;
            $sale->save();

            $mail = new TicketMail($sale);
            Mail::to($request->email)->send($mail);

            return response()->json(['message' => 'El ticket ha sido enviado'], 200);
        } catch (ModelNotFoundException $e) {
            DB::rollBack();
            return response()->json(['error' => 'No content 1'], 406);
        } catch (ValidationException $e) {
            DB::rollBack();
            return response()->json(['error' => 'Bad Request', 'errors' => $e->errors()], 400);
        } catch (\Throwable $e) {
            DB::rollBack();
            return response()->json(['error' => $e->getMessage()], 406);
        }
    }

    public function update(Request $request, $id)
    {
        // try {
        //     DB::beginTransaction();

        //     $this->validate($request, $this->validator($request));

        //     $sale = Sale::find($id);
        //     if (!$sale) return response()->json(['error' => 'Bad URI'], 404);

        //     $operation = $sale->operation;
        //     if (!$operation) return response()->json(['error' => 'Bad URI'], 404);

        //     $data = $request->all();
        //     $sale->update($data);
        //     $operation->update($data);

        //     DB::commit();

        //     return response()->json([
        //         'message' => 'Venta actualizada correctamente',
        //         'sale' => Sale::with('operation')->find($sale->objectId)
        //     ], 201);
        // } catch (ModelNotFoundException $e) {
        //     DB::rollBack();
        //     return response()->json(['error' => 'No content 1'], 406);
        // } catch (ValidationException $e) {
        //     DB::rollBack();
        //     return response()->json(['error' => 'Bad Request', 'errors' => $e->errors()], 400);
        // } catch (\Throwable $e) {
        //     DB::rollBack();
        //     return response()->json(['error' => $e->getMessage()], 406);
        // }
    }

    public function destroy($id)
    {
        // try {
        //     DB::beginTransaction();

        //     $sale = Sale::find($id);
        //     if (!$sale) return response()->json(['error' => 'Bad URI'], 404);

        //     $operation = $sale->operation;
        //     if (!$operation) return response()->json(['error' => 'Bad URI'], 404);

        //     $business = $operation->studio->business;
        //     if ($business->objectId != Auth::user()->businessObjectId) {
        //         return response()->json([
        //             'logout' => true,
        //             'error' => 'Error de autenticación'
        //         ], 401);
        //     }

        //     $sale->operation->delete();
        //     $sale->delete();

        //     DB::commit();

        //     return response()->json(['message' => 'Venta eliminada exitosamente'], 200);
        // } catch (ModelNotFoundException $e) {
        //     DB::rollBack();
        //     return response()->json(['error' => 'No content 1'], 406);
        // } catch (\Throwable $e) {
        //     DB::rollBack();
        //     return response()->json(['error' => 'No content 2'], 406);
        // }
    }

    private function validator($request)
    {
        $data = $request->all();
        $rules = [
            'amount' => 'required|regex:/^(?!0\d)\d*(\.\d+)?$/',
            'concept' => 'nullable',
            // 'salePercentage' => 'required|regex:/^(?!0\d)\d*(\.\d+)?$/',
            'clientName' => 'required',
            // 'clientEmail' => 'nullable|min:5|max:60|regex:/^.+@.+[.]+.+$/',
            'advance' => 'nullable|regex:/^(?!0\d)\d*(\.\d+)?$/',
            'tattooArtistObjectId' => 'required',
            'paymentMethodObjectId' => 'required',
            'otherPaymentMethod' => 'nullable',
        ];

        $toValidate = [];
        foreach ($rules as $field => $rule) {
            if (array_key_exists($field, $data)) {
                $toValidate[$field] = $rule;
            }
        }

        return $toValidate;
    }
}
