<?php

namespace App\Http\Controllers;

use App\Custom\StripeErrorMessages;
use App\Custom\StripeIntervalCustom;
use App\Models\Admin;
use App\Models\Plan;
use App\Models\Studio;
use App\Models\TattooArtist;
use App\Models\User;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Stripe\Exception\ApiConnectionException;
use Stripe\Exception\ApiErrorException;
use Stripe\Exception\AuthenticationException;
use Stripe\StripeClient;
use Stripe\Exception\CardException;
use Stripe\Exception\InvalidRequestException;
use Stripe\Exception\RateLimitException;
use Stripe\Subscription;

class StripeController extends Controller
{

    public function getProducts()
    {
        try {
            $stripe = new StripeClient(env('STRIPE_SECRET_KEY'));

            $products = json_decode(json_encode($stripe->products->all([
                'active' => true
            ])), true);

            for ($i = 0; $i < count($products['data']); ++$i) {
                $prices = json_decode(json_encode($stripe->prices->all([
                    'product' => $products['data'][$i]['id'],
                    'active' => true
                ])), true);

                for ($j = 0; $j < count($prices['data']); ++$j) {
                    $recurring = $prices['data'][$j]['recurring'];

                    $interval = $recurring['interval'];
                    $intervalCount = $recurring['interval_count'];
                    $unitAmount = $prices['data'][$j]['unit_amount'];

                    $prices['data'][$j]['label'] = StripeIntervalCustom::getLabel([
                        'interval' => $interval,
                        'intervalCount' => $intervalCount,
                        'unitAmount' => $unitAmount
                    ]);
                }

                $products['data'][$i]['prices'] = $prices;
            }

            return response()->json(['products' => $products], 200);
        } catch (CardException $e) {
            $status = $e->getHttpStatus();
            $error = $e->getError();
            $type = 'Type is:' . $error->type . '\n';

            $code = array_key_exists($error->code, StripeErrorMessages::ES)
                ? StripeErrorMessages::ES[$error->code]
                : null;

            $declineCode = array_key_exists($e->getDeclineCode(), StripeErrorMessages::ES)
                ? StripeErrorMessages::ES[$e->getDeclineCode()]
                : null;

            $error = $declineCode ?? $code ?? $error->message;

            return response([
                'status' => $status,
                'type' => $type,
                'code' => $code,
                'declineCode' => $declineCode,
                'error' => $error
            ], 402);
        } catch (RateLimitException $e) {
            return response()->json([
                'error' => 'Demasiadas peticiones'
            ], 402);
        } catch (InvalidRequestException $e) {
            return response()->json([
                'error' => 'Parámetros incorrectos'
            ], 406);
        } catch (AuthenticationException $e) {
            return response()->json([
                'error' => 'Error de autenticación'
            ], 401);
        } catch (ApiConnectionException $e) {
            return response()->json([
                'error' => 'Error de red'
            ], 402);
        } catch (ApiErrorException $e) {
            return response()->json([
                'error' => 'Ocurrió un error'
            ], 400);
        } catch (Exception $e) {
            return response()->json([
                'error' => 'Ocurrió un error'
            ], 406);
        }
    }
    public function testApi()
    {
        try {
            $stripe = new StripeClient(env('STRIPE_SECRET_KEY'));

            $subscriptions = $stripe->customers->retrieve('cus_KzIX9jW5GE8taQ', [
                'expand' => ['subscriptions']
            ]);
            // $subscriptionItems = $stripe->subscriptionItems->all([]);
            // $subscriptionSchedules = $stripe->subscriptionSchedules->all([]);
            $stripe = new StripeClient(env('STRIPE_SECRET_KEY'));

            $products = $stripe->products->all([
                'active' => true
            ]);
            $prices = $stripe->prices->all([
                'product' => $products->data[0]->id
            ]);

            return response()->json($prices);
            return response()->json([
                $subscriptions,
                // $subscriptionItems,
                // $subscriptionSchedules
            ], 200);
        } catch (CardException $e) {
            $status = $e->getHttpStatus();
            $error = $e->getError();
            $type = 'Type is:' . $error->type . '\n';

            $code = array_key_exists($error->code, StripeErrorMessages::ES)
                ? StripeErrorMessages::ES[$error->code]
                : null;

            $declineCode = array_key_exists($e->getDeclineCode(), StripeErrorMessages::ES)
                ? StripeErrorMessages::ES[$e->getDeclineCode()]
                : null;

            $error = $declineCode ?? $code ?? $error->message;

            return response([
                'status' => $status,
                'type' => $type,
                'code' => $code,
                'declineCode' => $declineCode,
                'error' => $error
            ], 402);
        } catch (RateLimitException $e) {
            return response()->json([
                'error' => 'Demasiadas peticiones'
            ], 402);
        } catch (InvalidRequestException $e) {
            return response()->json([
                'error' => 'Parámetros incorrectos'
            ], 406);
        } catch (AuthenticationException $e) {
            return response()->json([
                'error' => 'Error de autenticación'
            ], 401);
        } catch (ApiConnectionException $e) {
            return response()->json([
                'error' => 'Error de red'
            ], 402);
        } catch (ApiErrorException $e) {
            return response()->json([
                'error' => 'Ocurrió un error'
            ], 400);
        } catch (Exception $e) {
            return response()->json([
                'error' => 'Ocurrió un error'
            ], 406);
        }
    }

    public function getUpcomingInvoice(Request $request, $id)
    {
        try {
            $stripe = new StripeClient(env('STRIPE_SECRET_KEY'));
            $admin = Admin::where('isDeleted', false)->find($id);
            $customerId = $admin ? $admin->customerId : null;

            $subscriptions = $stripe->subscriptions->all([
                'customer' => $customerId,
                'limit' => 1
            ]);

            $subscription = count($subscriptions->data) > 0 ? $subscriptions->data[0] : null;

            if (!$subscription)
                return response()->json([], 200);

            $items = [];

            if ($request->price)
                $items = [
                    [
                        'id' => $subscription->items->data[0]->id,
                        'price' => $request->price,
                    ],
                ];
            else
                $items = [['id' => $subscription->items->data[0]->id]];

            $prorationDate = time();

            $upcomingInvoice = $stripe->invoices->upcoming([
                'customer' => $customerId,
                'subscription' => $subscription->id,
                'subscription_items' => $items,
                'subscription_proration_date' => $prorationDate
            ]);

            return response()->json([
                'upcomingInvoice' => $upcomingInvoice
            ], 200);
        } catch (CardException $e) {
            $status = $e->getHttpStatus();
            $error = $e->getError();
            $type = 'Type is:' . $error->type . '\n';

            $code = array_key_exists($error->code, StripeErrorMessages::ES)
                ? StripeErrorMessages::ES[$error->code]
                : null;

            $declineCode = array_key_exists($e->getDeclineCode(), StripeErrorMessages::ES)
                ? StripeErrorMessages::ES[$e->getDeclineCode()]
                : null;

            $error = $declineCode ?? $code ?? $error->message;

            return response([
                'status' => $status,
                'type' => $type,
                'code' => $code,
                'declineCode' => $declineCode,
                'error' => $error
            ], 402);
        } catch (RateLimitException $e) {
            return response()->json([
                'error' => 'Demasiadas peticiones'
            ], 402);
        } catch (InvalidRequestException $e) {
            return response()->json([
                'error' => 'Parámetros incorrectos'
            ], 406);
        } catch (AuthenticationException $e) {
            return response()->json([
                'error' => 'Error de autenticación'
            ], 401);
        } catch (ApiConnectionException $e) {
            return response()->json([
                'error' => 'Error de red'
            ], 402);
        } catch (ApiErrorException $e) {
            return response()->json([
                'error' => 'Ocurrió un error'
            ], 400);
        } catch (Exception $e) {
            return response()->json([
                'error' => 'Ocurrió un error'
            ], 406);
        }
    }

    public function cancelSubscription(Request $request, $id)
    {
        try {
            $stripe = new StripeClient(env('STRIPE_SECRET_KEY'));
            $admin = Admin::where('isDeleted', false)->find($id);
            $customerId = $admin ? $admin->customerId : null;

            $subscriptions = $stripe->subscriptions->all([
                'customer' => $customerId,
                'limit' => 1
            ])->data;

            if (count($subscriptions) == 0) {
                return response()->json([
                    'error' => 'No hay suscripciones por eliminar'
                ], 406);
            }

            $stripe->subscriptions->cancel(
                $subscriptions[0]->id,
                []
            );

            return response()->json([
                'message' => 'Suscripción cancelada exitosamente'
            ], 200);
        } catch (CardException $e) {
            $status = $e->getHttpStatus();
            $error = $e->getError();
            $type = 'Type is:' . $error->type . '\n';

            $code = array_key_exists($error->code, StripeErrorMessages::ES)
                ? StripeErrorMessages::ES[$error->code]
                : null;

            $declineCode = array_key_exists($e->getDeclineCode(), StripeErrorMessages::ES)
                ? StripeErrorMessages::ES[$e->getDeclineCode()]
                : null;

            $error = $declineCode ?? $code ?? $error->message;

            return response([
                'status' => $status,
                'type' => $type,
                'code' => $code,
                'declineCode' => $declineCode,
                'error' => $error
            ], 402);
        } catch (RateLimitException $e) {
            return response()->json([
                'error' => 'Demasiadas peticiones'
            ], 402);
        } catch (InvalidRequestException $e) {
            return response()->json([
                'error' => 'Parámetros incorrectos'
            ], 406);
        } catch (AuthenticationException $e) {
            return response()->json([
                'error' => 'Error de autenticación'
            ], 401);
        } catch (ApiConnectionException $e) {
            return response()->json([
                'error' => 'Error de red'
            ], 402);
        } catch (ApiErrorException $e) {
            return response()->json([
                'error' => 'Ocurrió un error'
            ], 400);
        } catch (Exception $e) {
            return response()->json([
                'error' => 'Ocurrió un error'
            ], 406);
        }
    }

    public function createSubscription(Request $request, $id)
    {
        try {
            $admin = Admin::find($id);
            // $users = User::where([
            //     ['isDeleted', false],
            //     ['email', $request->email]
            // ])->count();
            // if ($users > 0)
            //     return response()->json([
            //         'error' => 'Ya existe una cuenta con este correo'
            //     ], 406);

            $stripe = new StripeClient(env('STRIPE_SECRET_KEY'));
            $customer = $stripe->customers->create([
                'description' => $request->cardOwner,
                'email' => $request->email,
                'payment_method' => $request->paymentMethod,
                'invoice_settings' => [
                    'default_payment_method' => $request->paymentMethod
                ]
            ]);

            $subscription = $stripe->subscriptions->create([
                'customer' => $customer->id,
                'items' => [
                    ['price' => $request->price],
                ],
                'payment_behavior' => 'default_incomplete',
                'expand' => ['latest_invoice.payment_intent']
            ]);

            $admin->update([
                'customerId' => $customer->id
            ]);

            $clientSecret = $subscription
                ->latest_invoice
                ->payment_intent
                ->client_secret;

            return response()->json([
                'subscriptionId' => $subscription->id,
                'clientSecret' => $clientSecret,
                'customerId' => $customer->id
            ], 201);
        } catch (CardException $e) {
            $admin = Admin::find($id);
            if ($admin) {
                $business = $admin->business;
                if ($business) {
                    $business->deleteBusiness();
                }
            }
            // Since it's a decline, \Stripe\Exception\CardException will be caught
            $status = $e->getHttpStatus();
            $error = $e->getError();
            $type = 'Type is:' . $error->type . '\n';

            $code = array_key_exists($error->code, StripeErrorMessages::ES)
                ? StripeErrorMessages::ES[$error->code]
                : null;

            $declineCode = array_key_exists($e->getDeclineCode(), StripeErrorMessages::ES)
                ? StripeErrorMessages::ES[$e->getDeclineCode()]
                : null;

            $error = $declineCode ?? $code ?? $error->message;

            // param is '' in this case
            // $param = $error->param;
            // $message = $error->message;

            return response([
                'status' => $status,
                'type' => $type,
                'code' => $code,
                // 'param' => $param,
                'declineCode' => $declineCode,
                'error' => $error
            ], 402);
        } catch (RateLimitException $e) {
            $admin = Admin::find($id);
            if ($admin) {
                $business = $admin->business;
                if ($business) {
                    $business->deleteBusiness();
                }
            }
            // Too many requests made to the API too quickly
            return response()->json([
                'error' => 'Demasiadas peticiones'
            ], 402);
        } catch (InvalidRequestException $e) {
            $admin = Admin::find($id);
            if ($admin) {
                $business = $admin->business;
                if ($business) {
                    $business->deleteBusiness();
                }
            }
            // Invalid parameters were supplied to Stripe's API
            return response()->json([
                'error' => 'Parámetros incorrectos'
            ], 406);
        } catch (AuthenticationException $e) {
            $admin = Admin::find($id);
            if ($admin) {
                $business = $admin->business;
                if ($business) {
                    $business->deleteBusiness();
                }
            }
            // Authentication with Stripe's API failed
            // (maybe you changed API keys recently)
            return response()->json([
                'error' => 'Error de autenticación'
            ], 401);
        } catch (ApiConnectionException $e) {
            $admin = Admin::find($id);
            if ($admin) {
                $business = $admin->business;
                if ($business) {
                    $business->deleteBusiness();
                }
            }
            // Network communication with Stripe failed
            return response()->json([
                'error' => 'Error de red'
            ], 402);
        } catch (ApiErrorException $e) {
            $admin = Admin::find($id);
            if ($admin) {
                $business = $admin->business;
                if ($business) {
                    $business->deleteBusiness();
                }
            }
            // Display a very generic error to the user, and maybe send
            // yourself an email
            return response()->json([
                'error' => 'Ocurrió un error'
            ], 400);
        } catch (Exception $e) {
            $admin = Admin::find($id);
            if ($admin) {
                $business = $admin->business;
                if ($business) {
                    $business->deleteBusiness();
                }
            }
            // Something else happened, completely unrelated to Stripe
            return response()->json([
                'error' => 'Ocurrió un error'
            ], 406);
        }
    }

    public function subscription(Request $request)
    {
        try {
            $stripe = new StripeClient(env('STRIPE_SECRET_KEY'));
            $customer = $stripe->customers->create([
                'description' => $request->name,
                'email' => $request->email,
                // 'payment_method' => $request->paymentMethod,
                'invoice_settings' => [
                    'default_payment_method' => $request->paymentMethod
                ]
            ]);

            $subscription = $stripe->subscriptions->create([
                'customer' => $customer->id,
                'items' => [
                    ['price' => $request->price],
                ],
                'payment_behavior' => 'default_incomplete',
                'expand' => ['latest_invoice.payment_intent']
            ]);

            $clientSecret = $subscription->latest_invoice->payment_intent->client_secret;

            return response()->json([
                'subscriptionId' => $subscription->id,
                'clientSecret' => $clientSecret,
                // 'confirmPayment' => $confirmPayment
            ], 200);
        } catch (CardException $e) {
            // Since it's a decline, \Stripe\Exception\CardException will be caught
            $status = $e->getHttpStatus();
            $error = $e->getError();
            $type = 'Type is:' . $error->type . '\n';

            $code = array_key_exists($error->code, StripeErrorMessages::ES)
                ? StripeErrorMessages::ES[$error->code]
                : null;

            $declineCode = array_key_exists($e->getDeclineCode(), StripeErrorMessages::ES)
                ? StripeErrorMessages::ES[$e->getDeclineCode()]
                : null;

            $error = $declineCode ?? $code ?? $error->message;

            // param is '' in this case
            // $param = $error->param;
            // $message = $error->message;

            return response([
                'status' => $status,
                'type' => $type,
                'code' => $code,
                // 'param' => $param,
                'declineCode' => $declineCode,
                'error' => $error
            ], 402);
        } catch (RateLimitException $e) {
            // Too many requests made to the API too quickly
            return response()->json([
                'error' => 'Demasiadas peticiones'
            ], 402);
        } catch (InvalidRequestException $e) {
            // Invalid parameters were supplied to Stripe's API
            return response()->json([
                'error' => 'Parámetros incorrectos'
            ], 406);
        } catch (AuthenticationException $e) {
            // Authentication with Stripe's API failed
            // (maybe you changed API keys recently)
            return response()->json([
                'error' => 'Error de autenticación'
            ], 401);
        } catch (ApiConnectionException $e) {
            // Network communication with Stripe failed
            return response()->json([
                'error' => 'Error de red'
            ], 402);
        } catch (ApiErrorException $e) {
            // Display a very generic error to the user, and maybe send
            // yourself an email
            return response()->json([
                'error' => 'Ocurrió un error'
            ], 400);
        } catch (Exception $e) {
            // Something else happened, completely unrelated to Stripe
            return response()->json([
                'error' => 'Ocurrió un error'
            ], 406);
        }
    }

    public function changePriceSubscription(Request $request, $id)
    {
        try {
            $stripe = new StripeClient(env('STRIPE_SECRET_KEY'));
            $admin = Admin::where('isDeleted', false)->find($id);
            $customerId = $admin ? $admin->customerId : null;

            $subscriptions = $stripe->subscriptions->all([
                'customer' => $customerId,
                'limit' => 1
            ]);

            $subscription = count($subscriptions->data) > 0
                ? $subscriptions->data[0]
                : null;

            if (!$subscription) {
                $subscription = $stripe->subscriptions->create([
                    'customer' => $customerId,
                    'items' => [
                        ['price' => $request->price],
                    ]
                ]);

                $plan = Plan::where('productId', $subscription->plan->product)->first();

                $admin->update([
                    'startDate' => date('Y-m-d H:i:s', $subscription->current_period_start),
                    'endDate' => date('Y-m-d H:i:s', $subscription->current_period_end),
                    'planObjectId' => $plan->objectId
                ]);

                return response()->json([
                    'subscription' => $subscription,
                    'message' => 'Suscripción activada correctamente'
                ], 200);
            } else {
                $items = $subscription->items;
                $item = count($items->data) > 0
                    ? $items->data[0]
                    : null;

                if (!$item)
                    return response()->json([
                        'error' => 'Suscripción inválida'
                    ], 406);

                // $subscriptionId = $subscription->plan->product ?? null;
                // // return response()->json([$subscriptionId], 406);
                // $plan = Plan::where('productId', $subscriptionId)->first();

                // $admin = Auth::user();
                // $businessObjectId = $admin->businessObjectId;

                // $studios = Studio::where([
                //     ['isDeleted', false],
                //     ['businessObjectId', $businessObjectId]
                // ])->get();

                // $studiosCount = Studio::where([
                //     ['isDeleted', false],
                //     ['businessObjectId', $businessObjectId]
                // ])->count();

                // $tattooArtists = 0;

                // foreach ($studios as $studio) {
                //     $currentTattooArtists = TattooArtist::where([
                //         ['isDeleted', false],
                //         ['studioObjectId', $studio->objectId]
                //     ])->count();

                //     $tattooArtists += $currentTattooArtists;
                // }

                // if ($plan->studiosLimit != -1 && $plan->tattooArtistsLimit != -1) {
                //     if ($plan->studiosLimit < $studiosCount || $plan->tattooArtistsLimit < $tattooArtists) {
                //         return response()->json([
                //             'error' => 'Tu suscripción no cumple con los requisitos para actualizarse'
                //         ], 406);
                //     }
                // }

                $stripe->subscriptions->update(
                    $subscription->id,
                    [
                        'items' => [
                            [
                                'id' => $item->id,
                                'price' => $request->price
                            ]
                        ]
                    ]
                );
            }

            return response()->json([
                'message' => 'La suscripción ha sido actualizada exitosamente',
                'subscription' => $subscription
            ], 200);
        } catch (CardException $e) {
            $status = $e->getHttpStatus();
            $error = $e->getError();
            $type = 'Type is:' . $error->type . '\n';

            $code = array_key_exists($error->code, StripeErrorMessages::ES)
                ? StripeErrorMessages::ES[$error->code]
                : null;

            $declineCode = array_key_exists($e->getDeclineCode(), StripeErrorMessages::ES)
                ? StripeErrorMessages::ES[$e->getDeclineCode()]
                : null;

            $error = $declineCode ?? $code ?? $error->message;

            return response([
                'status' => $status,
                'type' => $type,
                'code' => $code,
                'declineCode' => $declineCode,
                'error' => $error
            ], 402);
        } catch (RateLimitException $e) {
            return response()->json([
                'error' => 'Demasiadas peticiones'
            ], 402);
        } catch (InvalidRequestException $e) {
            return response()->json([
                'error' => 'Parámetros incorrectos'
            ], 406);
        } catch (AuthenticationException $e) {
            return response()->json([
                'error' => 'Error de autenticación'
            ], 401);
        } catch (ApiConnectionException $e) {
            return response()->json([
                'error' => 'Error de red'
            ], 402);
        } catch (ApiErrorException $e) {
            return response()->json([
                'error' => 'Ocurrió un error'
            ], 400);
        } catch (Exception $e) {
            return response()->json([
                'error' => 'Ocurrió un error',
                'm' => $e->getMessage()
            ], 406);
        }
    }

    public function getCustomerSubscription(Request $request, $id)
    {
        try {
            $stripe = new StripeClient(env('STRIPE_SECRET_KEY'));
            $admin = Admin::where('isDeleted', false)->find($id);
            $customerId = $admin ? $admin->customerId : null;

            $subscription = $stripe->subscriptions->all([
                'customer' => $customerId,
                'limit' => 1
            ]);

            return response()->json([
                'subscription' => count($subscription->data) > 0 ? $subscription->data[0] : null
            ], 200);
        } catch (CardException $e) {
            $status = $e->getHttpStatus();
            $error = $e->getError();
            $type = 'Type is:' . $error->type . '\n';

            $code = array_key_exists($error->code, StripeErrorMessages::ES)
                ? StripeErrorMessages::ES[$error->code]
                : null;

            $declineCode = array_key_exists($e->getDeclineCode(), StripeErrorMessages::ES)
                ? StripeErrorMessages::ES[$e->getDeclineCode()]
                : null;

            $error = $declineCode ?? $code ?? $error->message;

            return response([
                'status' => $status,
                'type' => $type,
                'code' => $code,
                'declineCode' => $declineCode,
                'error' => $error
            ], 402);
        } catch (RateLimitException $e) {
            return response()->json([
                'error' => 'Demasiadas peticiones'
            ], 402);
        } catch (InvalidRequestException $e) {
            return response()->json([
                'error' => 'Parámetros incorrectos'
            ], 406);
        } catch (AuthenticationException $e) {
            return response()->json([
                'error' => 'Error de autenticación'
            ], 401);
        } catch (ApiConnectionException $e) {
            return response()->json([
                'error' => 'Error de red'
            ], 402);
        } catch (ApiErrorException $e) {
            return response()->json([
                'error' => 'Ocurrió un error'
            ], 400);
        } catch (Exception $e) {
            return response()->json([
                'error' => 'Ocurrió un error'
            ], 406);
        }
    }

    public function getCustomer(Request $request, $id)
    {
        try {
            $stripe = new StripeClient(env('STRIPE_SECRET_KEY'));
            $admin = Admin::where('isDeleted', false)->find($id);
            $customerId = $admin ? $admin->customerId : null;

            $customer = $stripe->customers->retrieve($customerId, []);

            return response()->json([
                'customer' => $customer
            ], 200);
        } catch (CardException $e) {
            $status = $e->getHttpStatus();
            $error = $e->getError();
            $type = 'Type is:' . $error->type . '\n';

            $code = array_key_exists($error->code, StripeErrorMessages::ES)
                ? StripeErrorMessages::ES[$error->code]
                : null;

            $declineCode = array_key_exists($e->getDeclineCode(), StripeErrorMessages::ES)
                ? StripeErrorMessages::ES[$e->getDeclineCode()]
                : null;

            $error = $declineCode ?? $code ?? $error->message;

            return response([
                'status' => $status,
                'type' => $type,
                'code' => $code,
                'declineCode' => $declineCode,
                'error' => $error
            ], 402);
        } catch (RateLimitException $e) {
            return response()->json([
                'error' => 'Demasiadas peticiones'
            ], 402);
        } catch (InvalidRequestException $e) {
            return response()->json([
                'error' => 'Parámetros incorrectos'
            ], 406);
        } catch (AuthenticationException $e) {
            return response()->json([
                'error' => 'Error de autenticación'
            ], 401);
        } catch (ApiConnectionException $e) {
            return response()->json([
                'error' => 'Error de red'
            ], 402);
        } catch (ApiErrorException $e) {
            return response()->json([
                'error' => 'Ocurrió un error'
            ], 400);
        } catch (Exception $e) {
            return response()->json([
                'error' => 'Ocurrió un error'
            ], 406);
        }
    }

    public function getPaymentMethods(Request $request, $id)
    {
        try {
            $stripe = new StripeClient(env('STRIPE_SECRET_KEY'));
            $admin = Admin::where('isDeleted', false)->find($id);
            $customerId = $admin ? $admin->customerId : null;

            $customer = $stripe->customers->retrieve($customerId, []);
            $customerPaymentMethods = $stripe->customers->allPaymentMethods(
                $customer->id,
                ['type' => 'card']
            );

            return response()->json([
                'customerPaymentMethods' => $customerPaymentMethods
            ], 200);
        } catch (CardException $e) {
            // Since it's a decline, \Stripe\Exception\CardException will be caught
            $status = $e->getHttpStatus();
            $error = $e->getError();
            $type = 'Type is:' . $error->type . '\n';

            $code = array_key_exists($error->code, StripeErrorMessages::ES)
                ? StripeErrorMessages::ES[$error->code]
                : null;

            $declineCode = array_key_exists($e->getDeclineCode(), StripeErrorMessages::ES)
                ? StripeErrorMessages::ES[$e->getDeclineCode()]
                : null;

            $error = $declineCode ?? $code ?? $error->message;

            // param is '' in this case
            // $param = $error->param;
            // $message = $error->message;

            return response([
                'status' => $status,
                'type' => $type,
                'code' => $code,
                // 'param' => $param,
                'declineCode' => $declineCode,
                'error' => $error
            ], 402);
        } catch (RateLimitException $e) {
            // Too many requests made to the API too quickly
            return response()->json([
                'error' => 'Demasiadas peticiones'
            ], 402);
        } catch (InvalidRequestException $e) {
            // Invalid parameters were supplied to Stripe's API
            return response()->json([
                'error' => 'Parámetros incorrectos'
            ], 406);
        } catch (AuthenticationException $e) {
            // Authentication with Stripe's API failed
            // (maybe you changed API keys recently)
            return response()->json([
                'error' => 'Error de autenticación'
            ], 401);
        } catch (ApiConnectionException $e) {
            // Network communication with Stripe failed
            return response()->json([
                'error' => 'Error de red'
            ], 402);
        } catch (ApiErrorException $e) {
            // Display a very generic error to the user, and maybe send
            // yourself an email
            return response()->json([
                'error' => 'Ocurrió un error'
            ], 400);
        } catch (Exception $e) {
            // Something else happened, completely unrelated to Stripe
            return response()->json([
                'error' => 'Ocurrió un error'
            ], 406);
        }
    }

    public function removePaymentMethod(Request $request)
    {
        try {
            $paymentMethod = $request->paymentMethod;
            $stripe = new StripeClient(env('STRIPE_SECRET_KEY'));

            $stripe->paymentMethods->detach(
                $paymentMethod,
                []
            );

            return response()->json([
                'message' => 'El método de pago ha sido eliminado exitosamente'
            ], 200);
        } catch (CardException $e) {
            $status = $e->getHttpStatus();
            $error = $e->getError();
            $type = 'Type is:' . $error->type . '\n';

            $code = array_key_exists($error->code, StripeErrorMessages::ES)
                ? StripeErrorMessages::ES[$error->code]
                : null;

            $declineCode = array_key_exists($e->getDeclineCode(), StripeErrorMessages::ES)
                ? StripeErrorMessages::ES[$e->getDeclineCode()]
                : null;

            $error = $declineCode ?? $code ?? $error->message;

            return response([
                'status' => $status,
                'type' => $type,
                'code' => $code,
                // 'param' => $param,
                'declineCode' => $declineCode,
                'error' => $error
            ], 402);
        } catch (RateLimitException $e) {
            return response()->json([
                'error' => 'Demasiadas peticiones'
            ], 402);
        } catch (InvalidRequestException $e) {
            return response()->json([
                'error' => 'Parámetros incorrectos'
            ], 406);
        } catch (AuthenticationException $e) {
            return response()->json([
                'error' => 'Error de autenticación'
            ], 401);
        } catch (ApiConnectionException $e) {
            return response()->json([
                'error' => 'Error de red'
            ], 402);
        } catch (ApiErrorException $e) {
            return response()->json([
                'error' => 'Ocurrió un error'
            ], 400);
        } catch (Exception $e) {
            return response()->json([
                'error' => $e->getMessage()
            ], 406);
        }
    }

    public function setDefaultPaymentMethod(Request $request, $id)
    {
        try {
            $paymentMethod = $request->paymentMethod;

            $stripe = new StripeClient(env('STRIPE_SECRET_KEY'));
            $admin = Admin::where('isDeleted', false)->find($id);
            $customerId = $admin ? $admin->customerId : null;

            $customer = $stripe->customers->retrieve($customerId, []);
            $stripe->customers->update(
                $customer->id,
                [
                    // 'default_source' => $paymentMethod,
                    'invoice_settings' => [
                        'default_payment_method' => $paymentMethod
                    ]
                ]
            );

            return response()->json([
                'message' => 'El método de pago predeterminado ha sido actualizado'
            ], 200);
        } catch (CardException $e) {
            $status = $e->getHttpStatus();
            $error = $e->getError();
            $type = 'Type is:' . $error->type . '\n';

            $code = array_key_exists($error->code, StripeErrorMessages::ES)
                ? StripeErrorMessages::ES[$error->code]
                : null;

            $declineCode = array_key_exists($e->getDeclineCode(), StripeErrorMessages::ES)
                ? StripeErrorMessages::ES[$e->getDeclineCode()]
                : null;

            $error = $declineCode ?? $code ?? $error->message;

            return response([
                'status' => $status,
                'type' => $type,
                'code' => $code,
                // 'param' => $param,
                'declineCode' => $declineCode,
                'error' => $error
            ], 402);
        } catch (RateLimitException $e) {
            return response()->json([
                'error' => 'Demasiadas peticiones'
            ], 402);
        } catch (InvalidRequestException $e) {
            return response()->json([
                'error' => 'Parámetros incorrectos'
            ], 406);
        } catch (AuthenticationException $e) {
            return response()->json([
                'error' => 'Error de autenticación'
            ], 401);
        } catch (ApiConnectionException $e) {
            return response()->json([
                'error' => 'Error de red'
            ], 402);
        } catch (ApiErrorException $e) {
            return response()->json([
                'error' => 'Ocurrió un error'
            ], 400);
        } catch (Exception $e) {
            return response()->json([
                'error' => 'Ocurrió un error'
            ], 406);
        }
    }

    public function createPaymentMethod(Request $request, $id)
    {
        try {
            $paymentMethod = $request->paymentMethod;
            $setDefaultPaymentMethod = !!$request->setDefaultPaymentMethod;

            $stripe = new StripeClient(env('STRIPE_SECRET_KEY'));
            $admin = Admin::where('isDeleted', false)->find($id);
            $customerId = $admin ? $admin->customerId : null;
            $customer = $stripe->customers->retrieve($customerId, []);

            $stripe->paymentMethods->attach(
                $paymentMethod,
                ['customer' => $customer->id]
            );

            if ($setDefaultPaymentMethod) {
                $stripe->customers->update(
                    $customer->id,
                    [
                        // 'default_source' => $paymentMethod,
                        'invoice_settings' => [
                            'default_payment_method' => $paymentMethod
                        ]
                    ]
                );
            }

            return response()->json([
                'message' => 'Método de pago creado exitosamente'
            ], 200);
        } catch (CardException $e) {
            // Since it's a decline, \Stripe\Exception\CardException will be caught
            $status = $e->getHttpStatus();
            $error = $e->getError();
            $type = 'Type is:' . $error->type . '\n';

            $code = array_key_exists($error->code, StripeErrorMessages::ES)
                ? StripeErrorMessages::ES[$error->code]
                : null;

            $declineCode = array_key_exists($e->getDeclineCode(), StripeErrorMessages::ES)
                ? StripeErrorMessages::ES[$e->getDeclineCode()]
                : null;

            $error = $declineCode ?? $code ?? $error->message;

            // param is '' in this case
            // $param = $error->param;
            // $message = $error->message;

            return response([
                'status' => $status,
                'type' => $type,
                'code' => $code,
                // 'param' => $param,
                'declineCode' => $declineCode,
                'error' => $error
            ], 402);
        } catch (RateLimitException $e) {
            // Too many requests made to the API too quickly
            return response()->json([
                'error' => 'Demasiadas peticiones'
            ], 402);
        } catch (InvalidRequestException $e) {
            // Invalid parameters were supplied to Stripe's API
            return response()->json([
                'error' => 'Parámetros incorrectos'
            ], 406);
        } catch (AuthenticationException $e) {
            // Authentication with Stripe's API failed
            // (maybe you changed API keys recently)
            return response()->json([
                'error' => 'Error de autenticación'
            ], 401);
        } catch (ApiConnectionException $e) {
            // Network communication with Stripe failed
            return response()->json([
                'error' => 'Error de red'
            ], 402);
        } catch (ApiErrorException $e) {
            // Display a very generic error to the user, and maybe send
            // yourself an email
            return response()->json([
                'error' => 'Ocurrió un error'
            ], 400);
        } catch (Exception $e) {
            // Something else happened, completely unrelated to Stripe
            return response()->json([
                'error' => 'Ocurrió un error'
            ], 406);
        }
    }

    public function cancelSubscriptionAtPeriodEnd(Request $request, $id)
    {
        try {
            $stripe = new StripeClient(env('STRIPE_SECRET_KEY'));
            $admin = Admin::where('isDeleted', false)->find($id);
            $customerId = $admin ? $admin->customerId : null;

            $subscriptions = $stripe->subscriptions->all([
                'customer' => $customerId,
                'limit' => 1
            ]);

            $subscription = count($subscriptions->data) > 0
                ? $subscriptions->data[0]
                : null;

            if (!$subscription) {
                return response()->json([
                    'error' => 'Suscripción inválida'
                ], 406);
            }

            $items = $subscription->items;
            $item = count($items->data) > 0
                ? $items->data[0]
                : null;

            if (!$item)
                return response()->json([
                    'error' => 'Suscripción inválida'
                ], 406);

            $stripe->subscriptions->update(
                $subscription->id,
                [
                    'cancel_at_period_end' => $request->cancelAtPeriodEnd
                ]
            );

            return response()->json([
                'message' => 'La suscripción ha sido actualizada exitosamente',
                'subscription' => $subscription
            ], 200);
        } catch (CardException $e) {
            $status = $e->getHttpStatus();
            $error = $e->getError();
            $type = 'Type is:' . $error->type . '\n';

            $code = array_key_exists($error->code, StripeErrorMessages::ES)
                ? StripeErrorMessages::ES[$error->code]
                : null;

            $declineCode = array_key_exists($e->getDeclineCode(), StripeErrorMessages::ES)
                ? StripeErrorMessages::ES[$e->getDeclineCode()]
                : null;

            $error = $declineCode ?? $code ?? $error->message;

            return response([
                'status' => $status,
                'type' => $type,
                'code' => $code,
                'declineCode' => $declineCode,
                'error' => $error
            ], 402);
        } catch (RateLimitException $e) {
            return response()->json([
                'error' => 'Demasiadas peticiones'
            ], 402);
        } catch (InvalidRequestException $e) {
            return response()->json([
                'error' => 'Parámetros incorrectos'
            ], 406);
        } catch (AuthenticationException $e) {
            return response()->json([
                'error' => 'Error de autenticación'
            ], 401);
        } catch (ApiConnectionException $e) {
            return response()->json([
                'error' => 'Error de red'
            ], 402);
        } catch (ApiErrorException $e) {
            return response()->json([
                'error' => 'Ocurrió un error'
            ], 400);
        } catch (Exception $e) {
            return response()->json([
                'error' => 'Ocurrió un error',
                'm' => $e->getMessage()
            ], 406);
        }
    }

    public function updatePaymentMethod(Request $request, $id)
    {
        try {
            $stripe = new StripeClient(env('STRIPE_SECRET_KEY'));
            $admin = Admin::where('isDeleted', false)->find($id);
            $customerId = $admin ? $admin->customerId : null;

            $customer = $stripe->customers->retrieve($customerId, []);

            $paymentMethod = $stripe->paymentMethods->create([
                'type' => 'card',
                'card' => [
                    'number' => '4242424242424242',
                    'exp_month' => 1,
                    'exp_year' => 2023,
                    'cvc' => '314',
                ],
            ]);

            $stripe->paymentMethods->attach(
                $paymentMethod->id,
                ['customer' => $customer->id]
            );

            $customerPaymentMethods = $stripe->customers->allPaymentMethods($customerId, [
                'type' => 'card'
            ]);

            return response()->json([
                'paymentMethod' => $paymentMethod,
                'customer' => $customer,
                'customerPaymentMethods' => $customerPaymentMethods
            ], 200);
        } catch (CardException $e) {
            // Since it's a decline, \Stripe\Exception\CardException will be caught
            $status = $e->getHttpStatus();
            $error = $e->getError();
            $type = 'Type is:' . $error->type . '\n';

            $code = array_key_exists($error->code, StripeErrorMessages::ES)
                ? StripeErrorMessages::ES[$error->code]
                : null;

            $declineCode = array_key_exists($e->getDeclineCode(), StripeErrorMessages::ES)
                ? StripeErrorMessages::ES[$e->getDeclineCode()]
                : null;

            $error = $declineCode ?? $code ?? $error->message;

            // param is '' in this case
            // $param = $error->param;
            // $message = $error->message;

            return response([
                'status' => $status,
                'type' => $type,
                'code' => $code,
                // 'param' => $param,
                'declineCode' => $declineCode,
                'error' => $error
            ], 402);
        } catch (RateLimitException $e) {
            // Too many requests made to the API too quickly
            return response()->json([
                'error' => 'Demasiadas peticiones'
            ], 402);
        } catch (InvalidRequestException $e) {
            // Invalid parameters were supplied to Stripe's API
            return response()->json([
                'error' => 'Parámetros incorrectos'
            ], 406);
        } catch (AuthenticationException $e) {
            // Authentication with Stripe's API failed
            // (maybe you changed API keys recently)
            return response()->json([
                'error' => 'Error de autenticación'
            ], 401);
        } catch (ApiConnectionException $e) {
            // Network communication with Stripe failed
            return response()->json([
                'error' => 'Error de red'
            ], 402);
        } catch (ApiErrorException $e) {
            // Display a very generic error to the user, and maybe send
            // yourself an email
            return response()->json([
                'error' => 'Ocurrió un error'
            ], 400);
        } catch (Exception $e) {
            // Something else happened, completely unrelated to Stripe
            return response()->json([
                'error' => 'Ocurrió un error'
            ], 406);
        }
    }
}
