<?php

namespace App\Http\Controllers;

use App\Models\Studio;
use App\Models\TattooArtist;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class StudioTattooArtistController extends Controller
{
    public function index($id)
    {
        try {
            $studio = Studio::where([
                ['isDeleted', false],
                ['businessObjectId', Auth::user()->businessObjectId]
            ])->find($id);

            if (!$studio) return response()->json(['error' => 'Bad URI'], 404);

            $tattooArtists = TattooArtist::with('user')
                ->where([
                    ['studioObjectId', $studio->objectId],
                    ['isDeleted', false]
                ])
                ->get();

            $plan = Auth::user()->plan;
            $limit = $plan
                ? $plan->tattooArtistsLimit
                : 0;

            return response()->json([
                'tattooArtists' => $tattooArtists,
                'limit' => $limit
            ], 200);
        } catch (ModelNotFoundException $e) {
            return response()->json(['error' => 'No content 1'], 406);
        } catch (\Throwable $e) {
            return response()->json(['error' => $e->getMessage()], 406);
        }
    }

    public function show($studio, $tattooArtist)
    {
        try {
            $studio = Studio::where([
                ['isDeleted', false],
                ['businessObjectId', Auth::user()->businessObjectId]
            ])->find($studio);

            if (!$studio) return response()->json(['error' => 'Bad URI'], 404);

            $tattooArtist = TattooArtist::with(['studio'])
                ->where([
                    ['studioObjectId', $studio->objectId],
                    ['isDeleted', false]
                ])
                ->find($tattooArtist);

            return response()->json(['tattooArtist' => $tattooArtist], 200);
        } catch (ModelNotFoundException $e) {
            return response()->json(['error' => 'No content 1'], 406);
        } catch (\Throwable $e) {
            return response()->json(['error' => $e->getMessage()], 406);
        }
    }
}
