<?php

namespace App\Http\Controllers;

use App\Models\Admin;
use App\Models\User;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;

class SuperAdminAdminController extends Controller
{
    public function index(Request $request)
    {
        try {
            $pages = ceil(
                Admin::leftJoin('plans', 'plans.objectId', '=', 'admins.planObjectId')
                    ->join('businesses', 'businesses.objectId', '=', 'admins.businessObjectId')
                    ->join('users', 'users.objectId', '=', 'admins.userObjectId')
                    ->where('users.isDeleted', '!=', null)
                    ->where('users.name', 'like', "%$request->search%")
                    ->count() / $request->perPage
            );

            // $users = Admin::with(['user' => function ($q) {
            //     $q->orderBy('name');
            // }, 'plan', 'business'])
            //     ->skip($request->currentPage * $request->perPage)
            //     ->take($request->perPage)
            //     ->where([['isDeleted', false]])
            //     ->get();

            $users = Admin::leftJoin('plans', 'plans.objectId', '=', 'admins.planObjectId')
                ->join('businesses', 'businesses.objectId', '=', 'admins.businessObjectId')
                ->join('users', 'users.objectId', '=', 'admins.userObjectId')
                ->where('users.isDeleted', '!=', null)
                ->where('users.name', 'like', "%$request->search%")
                ->orWhere('businesses.name', 'like', "%$request->search%")
                ->orderBy('users.name', $request->orderBy)
                ->select(
                    'users.name',
                    'admins.objectId',
                    'admins.startDate',
                    'admins.endDate',
                    'admins.isDisabled',
                    'businesses.name as businessName',
                    'plans.name as planName'
                )
                ->skip($request->currentPage * $request->perPage)
                ->take($request->perPage)
                ->get();


            $margin = 1339200;

            foreach ($users as $user) {
                $endDate = strtotime($user->endDate);

                $month = strtotime("$user->startDate + 1 month") + $margin;
                $semester = strtotime("$user->startDate + 6 month") + $margin;
                $year = strtotime("$user->startDate + 1 year") + $margin;

                if ($endDate <= $month) {
                    $periodicity = 'Mensual';
                } else if ($endDate <= $semester) {
                    $periodicity = 'Semestral';
                } else if ($endDate <= $year) {
                    $periodicity = 'Anual';
                }

                $periodicity = ($user->startDate && $user->endDate)
                    ? $periodicity
                    : 'NA';

                $user['periodicity'] = $periodicity;
            }

            return response()->json([
                'clients' => $users,
                'pages' => $pages
            ]);
        } catch (ModelNotFoundException $e) {
            return response()->json(['error' => 'No content 1'], 406);
        } catch (\Throwable $e) {
            return response()->json(['error' => 'No content 2'], 406);
        }
    }

    public function show(Request $request, $id)
    {
        try {
            $admin = Admin::with(['user', 'business', 'plan'])
                ->where([
                    ['isDeleted', false]
                ])->find($id);

            return response()->json(['admin' => $admin], 200);
        } catch (ModelNotFoundException $e) {
            return response()->json(['error' => 'No content 1'], 406);
        } catch (\Throwable $e) {
            return response()->json(['error' => 'No content 2'], 406);
        }
    }

    public function disableClient(Request $request, $id)
    {
        try {
            $admin = Admin::where([
                ['isDeleted', false]
            ])->find($id);

            $admin->update([
                'isDisabled' => 1
            ]);

            return response()->json(['message' => 'Cliente desactivado correctamente'], 200);
        } catch (ModelNotFoundException $e) {
            return response()->json(['error' => 'No content 1'], 406);
        } catch (\Throwable $e) {
            return response()->json(['error' => 'No content 2'], 406);
        }
    }

    public function enableClient(Request $request, $id)
    {
        try {
            $admin = Admin::where([
                ['isDeleted', false]
            ])->find($id);

            $admin->update([
                'isDisabled' => 0
            ]);

            return response()->json(['message' => 'Cliente activado correctamente'], 200);
        } catch (ModelNotFoundException $e) {
            return response()->json(['error' => 'No content 1'], 406);
        } catch (\Throwable $e) {
            return response()->json(['error' => 'No content 2'], 406);
        }
    }
}
