<?php

namespace App\Http\Controllers;

use App\Models\SuperAdmin;
use App\Models\User;
use App\Traits\FilesTrait;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\ValidationException;

class SuperAdminController extends Controller
{
    use FilesTrait;
    public function index()
    {
        try {
            //code...
        } catch (ModelNotFoundException $e) {
            return response()->json(['error' => 'No content 1'], 406);
        } catch (\Throwable $e) {
            return response()->json(['error' => 'No content 2'], 406);
        }
    }

    public function show()
    {
        try {
            $superAdmin = Auth::user();

            return response()->json([
                'superAdmin' => $superAdmin
            ], 200);
        } catch (ModelNotFoundException $e) {
            return response()->json(['error' => 'No content 1'], 406);
        } catch (\Throwable $e) {
            return response()->json(['error' => 'No content 2'], 406);
        }
    }

    public function store(Request $request)
    {
        try {
            //code...
        } catch (ModelNotFoundException $e) {
            return response()->json(['error' => 'No content 1'], 406);
        } catch (ValidationException $e) {
            return response()->json(['error' => 'Bad Request', 'errors' => $e->errors()], 400);
        } catch (\Throwable $e) {
            return response()->json(['error' => 'No content 2'], 406);
        }
    }

    public function update(Request $request)
    {
        try {

            $superAdmin = SuperAdmin::find(Auth::user()->objectId);

            $data = $request->all();
            unset($data['photo']);

            $checkMail = User::where('email', $request->email)->first();
            if ($checkMail) {
                if ($checkMail->objectId != $superAdmin->user->objectId) {
                    return response()->json([
                        'error' => 'Ya existe una cuenta con este correo'
                    ], 406);
                }
            }

            $superAdmin->update($data);
            $superAdmin->user->update($data);

            if ($request->hasFile('photo')) {
                $superAdmin->user->photo = $this->createFile(
                    'users',
                    'profilePhoto',
                    $superAdmin->user->objectId,
                    $request->photo
                );
                $superAdmin->user->save();
            }

            return response()->json([
                'message' => 'Usuario actualizado correctamente'
            ], 200);
        } catch (ModelNotFoundException $e) {
            return response()->json(['error' => 'No content 1'], 406);
        } catch (ValidationException $e) {
            return response()->json(['error' => 'Bad Request', 'errors' => $e->errors()], 400);
        } catch (\Throwable $e) {
            return response()->json(['error' => $e->getMessage()], 406);
        }
    }

    public function destroy($uuid)
    {
        try {
            //code...
        } catch (ModelNotFoundException $e) {
            return response()->json(['error' => 'No content 1'], 406);
        } catch (\Throwable $e) {
            return response()->json(['error' => 'No content 2'], 406);
        }
    }
}
