<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use App\Models\User;
use App\Models\TattooArtist;
use App\Models\Operation;
use App\Models\AdvancePayment;
use Illuminate\Support\Facades\Auth;

class TattooArtistAdvancePaymentController extends Controller
{
    public function index(Request $request, $id) {
        try {
            $tattooArtist = TattooArtist::find($id);
            $operations = Operation::where([
                ['tattooArtistObjectId', $id],
                ['advancePaymentObjectId', '!=', null]
            ])->get();

            if ($tattooArtist) {
                $businessObjectId = $tattooArtist->studio->businessObjectId;

                if (Auth::user()->businessObjectId != $businessObjectId)
                    $operations = [];
            }

            return response()->json(['operations' => $operations], 200);
        } catch (ModelNotFoundException $e) {
            return response()->json(['error' => 'No content 1'], 406);
        } catch (\Throwable $e) {
            return response()->json(['error' => $e->getMessage()], 406);
        }
    }
}
