<?php

namespace App\Http\Controllers;

use App\Models\Business;
use App\Models\Studio;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class TattooArtistBusinessController extends Controller
{
    public function show()
    {
        try {
            $id = Auth::user()->studioObjectId;
            $studio = Studio::where('isDeleted', false)
                ->find($id);
            $business = Business::where('isDeleted', false)
                ->find($studio->businessObjectId);

            return response()->json(['business' => $business], 200);
        } catch (ModelNotFoundException $e) {
            return response()->json(['error' => 'No content 1'], 406);
        } catch (\Throwable $e) {
            return response()->json(['error' => 'No content 2'], 406);
        }
    }
}
