<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use App\Models\User;
use App\Models\TattooArtist;
use App\Models\Payroll;
use Illuminate\Support\Facades\Auth;

class TattooArtistPayrollController extends Controller
{
    public function index(Request $request, $id) {
        try {
            $tattooArtist = TattooArtist::find($id);
            $payrolls = $tattooArtist->payrolls ?? [];

            if ($tattooArtist) {
                $businessObjectId = $tattooArtist->studio->businessObjectId;

                if (Auth::user()->businessObjectId != $businessObjectId)
                    $payrolls = [];
            }

            return response()->json(['payrolls' => $payrolls], 200);
        } catch (ModelNotFoundException $e) {
            return response()->json(['error' => 'No content 1'], 406);
        } catch (\Throwable $e) {
            return response()->json(['error' => $e->getMessage()], 406);
        }
    }
}
