<?php

namespace App\Http\Controllers;

use App\Models\Session;
use App\Models\TattooArtist;
use App\Models\User;
use App\Traits\FilesTrait;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Illuminate\Validation\ValidationException;

class UserController extends Controller {
    use FilesTrait;

    public function show($id) {
        try {
            $user = User::find($id);
            return response()->json(['user' => $user,], 200);
        } catch (ModelNotFoundException $e) {
            return response()->json(['error' => 'No content 1'], 406);
        } catch (\Throwable $e) {
            return response()->json(['error' => 'No content 2'], 406);
        }
    }
}
