<?php

namespace App\Http\Controllers;

use App\Mail\SuspendedAccount;
use App\Models\Admin;
use App\Models\Business;
use App\Models\Plan;
use App\Models\SubscriptionLog;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use Stripe\StripeClient;

class WebhookController extends Controller
{
    public function stripe(Request $request)
    {
        $message = 'Mensaje genérico';
        $stripe = new StripeClient(env('STRIPE_SECRET_KEY'));
        switch ($request->type) {
            case 'invoice.payment_succeeded':
                switch ($request->data['object']['billing_reason']) {
                    case 'subscription_create':
                        $message = 'Se creó una nueva suscripción';

                        $admin = Admin::where('customerId', $request->data['object']['customer'])->first();
                        $startDate = $request->data['object']['lines']['data'][0]['period']['start'];
                        $endDate = $request->data['object']['lines']['data'][0]['period']['end'];

                        $priceId = $request->data['object']['lines']['data'][0]['plan']['id'];
                        $price = $stripe->prices->retrieve($priceId, []);

                        $productId = $price->product;
                        $plan = Plan::where('productId', $productId)->first();

                        $admin->update([
                            'startDate' => date('Y-m-d H:i:s', $startDate),
                            'endDate' => date('Y-m-d H:i:s', $endDate),
                            'planObjectId' => $plan->objectId
                        ]);

                        $business = Business::where('isDeleted', false)
                            ->find($admin->businessObjectId);

                        SubscriptionLog::create([
                            'adminObjectId' => $admin->objectId,
                            'businessObjectId' => $business->objectId,
                            'planObjectId' => $plan->objectId,
                            'startDate' => date('Y-m-d H:i:s', $startDate),
                            'endDate' => date('Y-m-d H:i:s', $endDate),
                            'state' => $business->state,
                            'city' => $business->city,
                            'type' => 'create',
                        ]);

                        break;
                    case 'subscription_cycle':
                        $message = 'Se renovó una suscripción';

                        $admin = Admin::where('customerId', $request->data['object']['customer'])->first();
                        $startDate = $request->data['object']['lines']['data'][0]['period']['start'];
                        $endDate = $request->data['object']['lines']['data'][0]['period']['end'];

                        $priceId = $request->data['object']['lines']['data'][0]['plan']['id'];
                        $price = $stripe->prices->retrieve($priceId, []);

                        $productId = $price->product;
                        $plan = Plan::where('productId', $productId)->first();

                        $admin->update([
                            'startDate' => date('Y-m-d H:i:s', $startDate),
                            'endDate' => date('Y-m-d H:i:s', $endDate),
                            'planObjectId' => $plan->objectId
                        ]);

                        $business = Business::where('isDeleted', false)
                            ->find($admin->businessObjectId);

                        SubscriptionLog::create([
                            'adminObjectId' => $admin->objectId,
                            'businessObjectId' => $business->objectId,
                            'planObjectId' => $plan->objectId,
                            'startDate' => date('Y-m-d H:i:s', $startDate),
                            'endDate' => date('Y-m-d H:i:s', $endDate),
                            'state' => $business->state,
                            'city' => $business->city,
                            'type' => 'renovation',
                        ]);

                        break;
                    case 'subscription_update':
                        $message = 'Se actualizó una suscripción';

                        $admin = Admin::where('customerId', $request->data['object']['customer'])->first();
                        $startDate = $request->data['object']['lines']['data'][1]['period']['start'];
                        $endDate = $request->data['object']['lines']['data'][1]['period']['end'];

                        $priceId = $request->data['object']['lines']['data'][1]['plan']['id'];
                        $price = $stripe->prices->retrieve($priceId, []);

                        $productId = $price->product;
                        $plan = Plan::where('productId', $productId)->first();

                        $admin->update([
                            'startDate' => date('Y-m-d H:i:s', $startDate),
                            'endDate' => date('Y-m-d H:i:s', $endDate),
                            'planObjectId' => $plan->objectId
                        ]);

                        $business = Business::where('isDeleted', false)
                            ->find($admin->businessObjectId);

                        SubscriptionLog::create([
                            'adminObjectId' => $admin->objectId,
                            'businessObjectId' => $business->objectId,
                            'planObjectId' => $plan->objectId,
                            'startDate' => date('Y-m-d H:i:s', $startDate),
                            'endDate' => date('Y-m-d H:i:s', $endDate),
                            'state' => $business->state,
                            'city' => $business->city,
                            'type' => 'update',
                        ]);

                        break;
                    default:
                        $message = $request->data['object']['billing_reason'];
                        break;
                }
                break;
            case 'invoice.payment_failed':
                $message = 'Error con el pago';
                break;
            case 'customer.subscription.deleted':
                $message = 'Se eliminó una suscripción';

                $customerId = $request->data['object']['customer'];
                $admin = Admin::where('customerId', $customerId)->first();

                $admin->update([
                    'startDate' => null,
                    'endDate' => null,
                    'planObjectId' => null,
                    'deleteDate' => date('Y-m-d', strtotime('now + 3 months'))
                ]);

                $business = Business::where('isDeleted', false)
                    ->find($admin->businessObjectId);

                SubscriptionLog::create([
                    'adminObjectId' => $admin->objectId,
                    'businessObjectId' => $business->objectId,
                    'startDate' => date('Y-m-d H:i:s', time()),
                    'endDate' => date('Y-m-d H:i:s', time()),
                    'state' => $business->state,
                    'city' => $business->city,
                    'type' => 'delete',
                ]);

                $mail = new SuspendedAccount($admin, env('WEB_APP_URL') . "/subscription");
                Mail::to($admin->user->email)->send($mail);
                break;
            default:
                $message = 'Mensaje default';
                break;
        }

        // Storage::disk('public')->put(time() . 'txt', $request->type . "\n" . $message);
        return response()->json([$message], 200);
    }
}
