<?php

namespace App\Http\Middleware;

use App\Models\Session;
use App\Models\User;
use Closure;
use Illuminate\Contracts\Auth\Factory as Auth;

class Authenticate
{
    /**
     * The authentication guard factory instance.
     *
     * @var \Illuminate\Contracts\Auth\Factory
     */
    protected $auth;

    /**
     * Create a new middleware instance.
     *
     * @param  \Illuminate\Contracts\Auth\Factory  $auth
     * @return void
     */
    public function __construct(Auth $auth)
    {
        $this->auth = $auth;
    }

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @param  string|null  $guard
     * @return mixed
     */
    public function handle($request, Closure $next, $guard = null)
    {
        // return response()->json($this->auth->guard($guard)->guest());
        if ($this->auth->guard($guard)->guest()) {
            $session = Session::where('token', $request->header('Authorization'))->first();
            if (!$session) {
                return response()->json([
                    'logout' => true,
                    'disabled' => false,
                    'error' => 'Error de autenticación'
                ], 401);
            }

            if (strtotime('now') > strtotime($session->expirationDate)) {
                $session->delete();
                return response()->json([
                    'logout' => true,
                    'disabled' => false,
                    'error' => 'Error de autenticación'
                ], 401);
            }

            $user = $session->user;
            $user = $user ? User::where('isDeleted', false)->find($user->objectId) : null;
            $unauthorized = false;
            $disabled = false;

            if ($request->is('adminUser/*') || $request->is('unsubscribed/adminUser/*')) {
                $admin = $user ? $user->admin : null;
                $unauthorized = !$admin;
            } else if ($request->is('superAdminUser/*')) {
                $unauthorized = !$user->superAdmin;
            } else if ($request->is('tattooArtistUser/*')) {
                $tattooArtist = $user ? $user->tattooArtist : null;
                $studio = $tattooArtist ? $tattooArtist->studio : null;
                $business = $studio ? $studio->business : null;
                $admin = $business ? $business->admin : null;

                $unauthorized = !$user->tattooArtist;
                $disabled = $admin ? $admin->isDisabled : $disabled;
            }

            if ($unauthorized || $disabled) {
                return response()->json([
                    'logout' => false,
                    'disabled' => $disabled,
                    'error' => 'Error de autenticación'
                ], 401);
            }

            // $session->delete();
            // return response()->json([
            //     'logout' => true,
            //     'entra' => 'aquí',
            //     'disabled' => $disabled,
            //     'error' => 'Error de autenticación'
            // ], 401);
        } else {
            $user = $this->auth->guard($guard)->user();
            $user = User::where('isDeleted', false)->find($user->user->objectId);

            $unauthorized = false;
            $disabled = false;
            $expiredSubscription = false;
            $admin = $user ? $user->admin : null;

            if (!$admin) {
                $tattooArtist = $user ? $user->tattooArtist : null;
                $studio = $tattooArtist ? $tattooArtist->studio : null;
                $business = $studio ? $studio->business : null;
                $admin = $business ? $business->admin : null;
            }

            $routes = $request->is('adminUser/*') || $request->is('tattooArtistUser/*');
            // return response()->json($routes, 401);
            if ($admin) {
                $startDate = strtotime($admin->startDate);
                $endDate = strtotime($admin->endDate);
                $currentDate = time();

                if ($routes) {
                    if ($currentDate > $endDate || $currentDate < $startDate) {
                        $expiredSubscription = true;
                        $unauthorized = true;
                    }
                    $disabled = $admin->isDisabled;
                }
            } else {
                $unauthorized = !$user->superAdmin;
            }

            if ($unauthorized || $expiredSubscription || $disabled) {
                return response()->json([
                    'logout' => false,
                    'expiredSubscription' => $expiredSubscription,
                    'disabled' => $disabled,
                    'error' => 'Error de autenticación'
                ], 401);
            }
        }

        return $next($request);
    }
}
