<?php

namespace App\Mail;

use App\Models\Payroll;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class PayrollMail extends Mailable
{
    use Queueable, SerializesModels;

    public $payroll;
    public $url;
    public $subject;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(Payroll $payroll)
    {
        $this->payroll = $payroll;
        $this->url = $payroll->pdf_url;
        $this->subject = 'Reporte de corte';
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->view('mails.payroll-mail')
            ->subject($this->subject);
    }
}
