<?php

namespace App\Mail;

use App\Models\Admin;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class RenewMembership extends Mailable
{
    use Queueable, SerializesModels;

    public $admin;
    public $url;
    public $subject;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(Admin $admin, $url)
    {
        $this->admin = $admin;
        $this->url = $url;
        $this->subject = '¡Renueva tu membresía!';
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->view('mails.renew-membership')
            ->subject($this->subject);
    }
}
