<?php

namespace App\Models;

use App\Traits\UsesUuid;
use Illuminate\Database\Eloquent\Model;

class Admin extends Model
{
    use UsesUuid;

    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = ['objectId'];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'startDate',
        'endDate',
        'customerId',
        'planObjectId',
        'isDisabled',
        'businessObjectId',
        'userObjectId',
        'isDeleted',
        'deleteDate',
        'subscriptionAlertSent',
        'deleteEmailSent'
    ];

    /* The model's default values for attributes. @var array*/
    protected $attributes = [
        'isDeleted' => false,
        'isDisabled' => false,
        'deleteEmailSent' => false
    ];

    protected $with = [
        'user'
    ];

    protected $appends = [
        'should_show_message'
    ];

    public function business()
    {
        return $this->belongsTo(Business::class, 'businessObjectId');
    }

    public function plan()
    {
        return $this->belongsTo(Plan::class, 'planObjectId');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'userObjectId');
    }

    public function getShouldShowMessageAttribute()
    {
        if ($this->endDate) {
            $dateShowMessage = strtotime("$this->endDate - 7 days");
            $currentDate = time();

            if ($currentDate >= $dateShowMessage && !$this->subscriptionAlertSent) {
                return true;
            }
        }

        return false;
    }
}
