<?php

namespace App\Models;

use App\Traits\UsesUuid;
use Illuminate\Database\Eloquent\Model;

class AdvancePayment extends Model
{
    use UsesUuid;

    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = ['objectId'];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [];

    /* The model's default values for attributes. @var array*/
    protected $attributes = [
        'isRecurring' => false
    ];

    public function operation() {
        return $this->hasOne(Operation::class, 'advancePaymentObjectId', 'objectId');
    }
}
