<?php

namespace App\Models;

use App\Traits\FilesTrait;
use App\Traits\UsesUuid;
use Illuminate\Database\Eloquent\Model;

class Business extends Model
{

    use UsesUuid, FilesTrait;

    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = ['objectId'];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',

        'address',
        'state',
        'city',

        'phone',
        'website',
        'email',
        'logo',
        'legend',

        'isDeleted',
        'sendTicket'
    ];

    /* The model's default values for attributes. @var array*/
    protected $attributes = [
        'isDeleted' => false,
        'sendTicket' => true
    ];

    public function admin()
    {
        return $this->hasOne(Admin::class, 'businessObjectId', 'objectId');
    }

    public function studios()
    {
        return $this->hasMany(Studio::class, 'businessObjectId', 'objectId');
    }

    public function forms()
    {
        return $this->hasMany(Form::class, 'businessObjectId', 'objectId');
    }

    public function deleteBusiness()
    {
        $this->isDeleted = true;
        $this->save();

        $this->admin->isDeleted = true;
        $this->admin->save();
        $this->admin->user->deleteUser();

        $this->deleteDirectory('business', $this->objectId);
        $this->studios->each->deleteStudio();
    }
}
