<?php

namespace App\Models;

use App\Traits\UsesUuid;
use Illuminate\Database\Eloquent\Model;

class DefaultQuestion extends Model
{
    use UsesUuid;

    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = ['objectId'];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'questionNumber',
        'question',
        'options',
        'type',
        'required',
        'alwaysRequired',
        'isDeleted',
    ];

    /* The model's default values for attributes. @var array*/
    protected $attributes = [
        'isDeleted' => false,
        'isDefault' => true,
    ];

    protected $casts = [
        'options' => 'array'
    ];
}
