<?php

namespace App\Models;

use App\Traits\UsesUuid;
use Illuminate\Database\Eloquent\Model;

class Form extends Model
{
    use UsesUuid;

    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = ['objectId'];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'isDeleted',
        'name',
        'businessObjectId'
    ];

    /* The model's default values for attributes. @var array*/
    protected $attributes = [
        'isDeleted' => false
    ];

    protected $with = [
        // 'questions'
    ];

    protected $appends = [
        'response_url',
        'qr_pdf_url'
    ];

    public function business() {
        return $this->belongsTo(Business::class, 'businessObjectId');
    }

    public function questions() {
        return $this->hasMany(Question::class, 'formObjectId', 'objectId');
    }

    public function getResponseUrlAttribute() {
        return
            env('WEB_APP_URL') . "/formularios/$this->objectId";
    }
    public function getQrPdfUrlAttribute() {
        return env('APP_URL') . "/guest/form-qr/$this->objectId";
    }
}
