<?php

namespace App\Models;

use App\Traits\FilesTrait;
use App\Traits\UsesUuid;
use Illuminate\Database\Eloquent\Model;

class FormResponse extends Model
{
    use UsesUuid, FilesTrait;

    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = ['objectId'];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'formObjectId',
        'signature',
        // 'finished',
        'studioObjectId',
        'isDeleted',
    ];

    /* The model's default values for attributes. @var array*/
    protected $attributes = [
        'isDeleted' => false,
        // 'finished' => false
    ];

    protected $casts = [];

    protected $appends = [
        'signaturePath'
    ];

    // protected $with = [
    //     'responses'
    // ];

    // public function responses() {
    //     return $this->hasMany(Response::class, 'formResponseObjectId', 'objectId');
    // }

    public function getSignaturePathAttribute() {
        if (!$this->signature) return null;

        return env('APP_URL') . "/uploads/$this->signature";
    }

    public function deleteFormResponse()
    {
        $this->isDeleted = true;
        $this->save();

        $path = "forms/$this->formObjectId/formResponses";
        $this->deleteDirectory($path, $this->objectId);

        $responses = Response::where('isDeleted', false)
            ->where('formResponseObjectId', $this->objectId)
            ->get();

        $responses->each->update([
            'isDeleted' => true
        ]);
    }
}
