<?php

namespace App\Models;

use App\Traits\UsesUuid;
use Illuminate\Database\Eloquent\Model;

class Operation extends Model
{
    use UsesUuid;

    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = ['objectId'];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'amount',
        'concept',
        'date',
        'tattooArtistObjectId',
        'studioObjectId',
        'saleObjectId',
        'advancePaymentObjectId'
    ];

    /* The model's default values for attributes. @var array*/
    protected $attributes = [];

    protected $with = [
        'sale',
        'advancePayment'
    ];

    protected $appends = [
        'has_payroll'
    ];

    public function sale() {
        return $this->belongsTo(Sale::class, 'saleObjectId');
    }

    public function advancePayment() {
        return $this->belongsTo(AdvancePayment::class, 'advancePaymentObjectId');
    }

    public function tattooArtist() {
        return $this->belongsTo(TattooArtist::class, 'tattooArtistObjectId');
    }

    public function studio() {
        return $this->belongsTo(Studio::class, 'studioObjectId');
    }

    public function deleteOperation() {
        $advancePayment = AdvancePayment::find($this->advancePaymentObjectId);
        $sale = Sale::find($this->saleObjectId);

        $this->delete();
        if ($advancePayment) $advancePayment->delete();
        if ($sale) $sale->delete();
    }

    public function getHasPayrollAttribute() {
        $tattooArtist = TattooArtist::find($this->tattooArtistObjectId);
        $startDate = date('Y-m-d H:i:s', strtotime($this->date));
        $endDate = date('Y-m-d H:i:s', strtotime("$this->date - 1 day"));

        $payroll = Payroll::whereDate('startDate', '<=', $startDate)
            ->whereDate('endDate', '>=', $endDate)
            ->where('tattooArtistObjectId', $tattooArtist->objectId)
            ->count();

        return $payroll > 0;
    }
}
