<?php

namespace App\Models;

use App\Custom\OperationCustom;
use App\Traits\UsesUuid;
use Illuminate\Database\Eloquent\Model;

class Payroll extends Model
{
    use UsesUuid;

    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = ['objectId'];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'startDate',
        'endDate',
        'tattooArtistObjectId'
    ];

    protected $with = [
        'tattooArtist'
    ];
    protected $appends = [
        'pdf_url'
    ];

    /* The model's default values for attributes. @var array*/
    protected $attributes = [];

    public function tattooArtist()
    {
        return $this->belongsTo(TattooArtist::class, 'tattooArtistObjectId');
    }

    public function getPdfUrlAttribute()
    {
        return env('APP_URL') . "/guest/payrolls/$this->objectId/pdf";
    }
}
