<?php

namespace App\Models;

use App\Traits\UsesUuid;
use Illuminate\Database\Eloquent\Model;

class Picture extends Model
{
    use UsesUuid;

    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = ['objectId'];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'path',
        'productObjectId',
        'isDeleted'
    ];

    /* The model's default values for attributes. @var array*/
    protected $attributes = [
        'isDeleted' => false
    ];

    protected $casts = [];

    protected $appends = [
        'fullPath'
    ];

    public function getFullPathAttribute() {
        return $this->path
            ? env('APP_URL') . "/uploads/$this->path"
            : null;
    }
}
