<?php

namespace App\Models;

use App\Traits\UsesUuid;
use Illuminate\Database\Eloquent\Model;

class Plan extends Model
{
    use UsesUuid;
    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = ['objectId'];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'productId',
        'name',
        'tattooArtistsLimit',
        'studiosLimit'
    ];

    /* The model's default values for attributes. @var array*/
    protected $attributes = [];

    protected $with = [];

    protected $appends = [];
}
