<?php

namespace App\Models;

use App\Traits\FilesTrait;
use App\Traits\UsesUuid;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Product extends Model
{

    use UsesUuid, FilesTrait;

    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = ['objectId'];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'price',
        'description',
        'businessObjectId',
        'isDeleted'
    ];

    /* The model's default values for attributes. @var array*/
    protected $attributes = [
        'isDeleted' => false
    ];

    protected $casts = [];

    public function deleteProduct() {
        try {
            DB::beginTransaction();
            $this->isDeleted = true;
            $this->save();

            $pictures = Picture::where('isDeleted', false)
                ->where('productObjectId', $this->objectId)
                ->get();

            $pictures->each->update([
                'isDeleted' => true
            ]);

            $path = "products";
            $this->deleteDirectory($path, $this->objectId);

            DB::commit();

            return $this;

        } catch(\Throwable $e) {
            DB::rollBack();
        }

    }
}
