<?php

namespace App\Models;

use App\Traits\UsesUuid;
use Illuminate\Database\Eloquent\Model;

class ProductPurchase extends Model
{
    use UsesUuid;

    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = ['objectId'];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'saleObjectId',
        'clientName',
        'clientEmail',
        'paymentMethod',
        'tattooArtistObjectId',
        'businessObjectId',
        'isDeleted',
    ];

    /* The model's default values for attributes. @var array*/
    protected $attributes = [
        'isDeleted' => false,
    ];

    protected $casts = [];

    protected $appends = [
        'total'
    ];

    public function getTotalAttribute() {
        $productPurchaseItems = ProductPurchaseItem::where('isDeleted', false)
            ->where('isCancelled', false)
            ->where('productPurchaseObjectId', $this->objectId)
            ->get();

        $total = 0;
        foreach($productPurchaseItems as $item) {
            $total += $item->total;
        }

        return $total;
    }
}
