<?php

namespace App\Models;

use App\Traits\UsesUuid;
use Illuminate\Database\Eloquent\Model;

class ProductPurchaseItem extends Model
{
    use UsesUuid;

    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = ['objectId'];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'price',
        'quantity',
        'description',
        'productPurchaseObjectId',
        'productObjectId',
        'isCancelled',
        'isDeleted'
    ];

    /* The model's default values for attributes. @var array*/
    protected $attributes = [
        'isDeleted' => false,
        'isCancelled' => false,
    ];

    protected $appends = [
        'total'
    ];

    protected $casts = [];

    public function getTotalAttribute() {
        return $this->quantity * ($this->price ?? 0);
    }
}
