<?php

namespace App\Models;

use App\Traits\UsesUuid;
use Illuminate\Database\Eloquent\Model;

class Sale extends Model
{
    use UsesUuid;

    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = ['objectId'];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'salePercentage',
        'advance',
        'clientName',
        'clientEmail',
        'paymentMethodObjectId',
        'otherPaymentMethod'
    ];

    protected $appends = [
        'hasProductPurchase'
    ];

    /* The model's default values for attributes. @var array*/
    protected $attributes = [];

    public function operation()
    {
        return $this->hasOne(Operation::class, 'saleObjectId', 'objectId');
    }

    public function paymentMethod()
    {
        return $this->belongsTo(PaymentMethod::class, 'paymentMethodObjectId');
    }

    public function getPdfUrlAttribute()
    {
        $operationObjectId = $this->operation->objectId;
        return env('APP_URL') . "/guest/sales/$operationObjectId/ticket";
    }

    public function getHasProductPurchaseAttribute() {
        $productPurchase = ProductPurchase::where('isDeleted', false)
            ->where('saleObjectId', $this->objectId)
            ->first();

        return !!$productPurchase;
    }
}
