<?php

namespace App\Models;

use App\Traits\FilesTrait;
use App\Traits\UsesUuid;
use Illuminate\Database\Eloquent\Model;

class Studio extends Model
{
    use UsesUuid, FilesTrait;

    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = ['objectId'];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',

        'address',
        'state',
        'city',

        'phone',
        'website',
        'email',
        'logo',
        'legend',

        'businessObjectId',
        'isDeleted'
    ];

    /* The model's default values for attributes. @var array*/
    protected $attributes = [
        'isDeleted' => false
    ];

    public function business()
    {
        return $this->belongsTo(Business::class, 'businessObjectId');
    }

    public function tattooArtists()
    {
        return $this->hasMany(TattooArtist::class, 'studioObjectId', 'objectId');
    }

    public function operations()
    {
        return $this->hasMany(Operation::class, 'studioObjectId', 'objectId');
    }

    public function deleteStudio()
    {
        $this->isDeleted = true;
        $this->save();

        $business = $this->business;
        $path = "business/$business->objectId/studio";
        $this->deleteDirectory($path, $this->objectId);

        $this->tattooArtists->each->deleteTattooArtist();
    }
}
