<?php

namespace App\Models;

use App\Traits\UsesUuid;
use Illuminate\Database\Eloquent\Model;

class TattooArtist extends Model
{

    use UsesUuid;

    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = ['objectId'];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'salePercentage',
        'studioObjectId',
        'userObjectId',
        'isDeleted'
    ];

    /* The model's default values for attributes. @var array*/
    protected $attributes = [
        'isDeleted' => false
    ];

    protected $with = [
        'user'
    ];

    public function studio()
    {
        return $this->belongsTo(Studio::class, 'studioObjectId');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'userObjectId');
    }

    public function operations()
    {
        return $this->hasMany(Operation::class, 'tattooArtistObjectId', 'objectId');
    }

    public function payrolls()
    {
        return $this->hasMany(Payroll::class, 'tattooArtistObjectId', 'objectId');
    }

    public function recurringCharges()
    {
        return $this->hasMany(RecurringCharge::class, 'tattooArtistObjectId', 'objectId');
    }

    public function deleteTattooArtist()
    {
        $this->isDeleted = true;
        $this->save();
        // $this->payrolls->each->delete();
        // $this->operations->each->deleteOperation();
        $this->user->deleteUser();
    }
}
