<?php

namespace App\Models;

use App\Traits\FilesTrait;
use App\Traits\UsesUuid;
use Illuminate\Auth\Authenticatable;
use Illuminate\Contracts\Auth\Access\Authorizable as AuthorizableContract;
use Illuminate\Contracts\Auth\Authenticatable as AuthenticatableContract;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Laravel\Lumen\Auth\Authorizable;

class User extends Model implements AuthenticatableContract, AuthorizableContract {
    use Authenticatable, Authorizable, HasFactory;

    use UsesUuid, FilesTrait;

    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = ['objectId'];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'photo',
        'token',
        'isDeleted'
    ];

    /* The model's default values for attributes. @var array*/
    protected $attributes = [
        'isDeleted' => false
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'recoveryCode',
        'recoveryCodeExpiration'
    ];

    public function tattooArtist() {
        return $this->hasOne(TattooArtist::class, 'userObjectId', 'objectId');
    }

    public function admin() {
        return $this->hasOne(Admin::class, 'userObjectId', 'objectId');
    }

    public function sessions() {
        return $this->hasMany(Session::class, 'userObjectId', 'objectId');
    }

    public function superAdmin() {
        return $this->hasOne(SuperAdmin::class, 'userObjectId', 'objectId');
    }

    public function deleteUser() {
        $this->isDeleted = true;
        $this->save();

        $this->deleteDirectory('users', $this->objectId);
        $this->sessions->each->delete();
    }

    public function getSetPasswordUrlAttribute() {
        $url = env("WEB_APP_URL", "http://localhost:3000") . "/set-password/$this->objectId/$this->recoveryCode";
        return $url;
    }
}
